﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace sharprd
{
    public class ConnectionTreeNode : CustomTreeNode, IComparable
    {
        public bool Folder { get; set; }

        private RDConnection connection;
        public RDConnection Connection {
            get
            {
                return connection;
            }
            set
            {
                this.connection = value;
                this.Text = value.Name;
            }
        }

        public ConnectionTreeNode(RDConnection connection)
            : base(connection.Name)
        {
            this.Connection = connection;
            this.Tag = connection.Description;
        }

        public override string ToString()
        {
            if (Connection != null && !string.IsNullOrEmpty(Connection.Name))
            {
                return Connection.Name;
            }

            return string.Empty;
        }

        #region IComparable Members

        public int CompareTo(object obj)
        {
            return Name.CompareTo(((ConnectionTreeNode)obj).Name);
        }

        #endregion
    }
}
