using System;
using System.Threading;
using System.Windows.Forms;

namespace sharprd
{
    static class Program
    {
        const string uniqueName = "7FEB315C-3B51-4E75-AC61-7BCEE4E5E127";

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            bool firstInstance;
            Mutex mutex = new Mutex(false, "Local\\" + uniqueName, out firstInstance);

            if (firstInstance)
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new MainWindow());
            }
            else
            {
                MessageBox.Show(
                    "Another instance of SharpRD is already running, please check tray icon or task manager for sharprd.exe process",
                    "Warning",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
            }
        }
    }
}