﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace sharprd
{
    public class Mapi
    {
        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
        public class MapiMessage
        {
            public int reserved;
            public string subject;
            public string noteText;
            public string messageType;
            public string dateReceived;
            public string conversationID;
            public int flags;
            public IntPtr originator;
            public int recipCount;
            public IntPtr recips;
            public int fileCount;
            public IntPtr files;
        }

        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
        public class MapiFileDesc
        {
            public int reserved;
            public int flags;
            public int position;
            public string path;
            public string name;
            public IntPtr type;
        }

        [DllImport("MAPI32.DLL")]
        static extern int MAPISendMail(IntPtr sess, IntPtr hwnd, MapiMessage message, int flg, int rsv);

        public static void Send(string subject, string body, string attachment)
        {
            MapiMessage msg = new MapiMessage();
            msg.subject = subject;
            msg.noteText = body;
            msg.fileCount = 1;

            MapiFileDesc mapiFileDesc = new MapiFileDesc();
            mapiFileDesc.position = -1;
            mapiFileDesc.name = Path.GetFileName(attachment);
            mapiFileDesc.path = attachment;
            IntPtr files = Marshal.AllocHGlobal(Marshal.SizeOf(typeof(MapiFileDesc)));
            Marshal.StructureToPtr(mapiFileDesc, files, false);
            msg.files = files;

            MAPISendMail(IntPtr.Zero, IntPtr.Zero, msg, 0x00000001 | 0x00000008, 0);

            Marshal.DestroyStructure((IntPtr)msg.files, typeof(MapiFileDesc));
            Marshal.FreeHGlobal(msg.files);
        }
    }
}