﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_FILE = System.IntPtr;

/* Type: ALLEGRO_CONFIG
 */
using ALLEGRO_CONFIG = System.IntPtr;
/* Type: ALLEGRO_CONFIG_SECTION
 */
using ALLEGRO_CONFIG_SECTION = System.IntPtr;
/* Type: ALLEGRO_CONFIG_ENTRY
 */
using ALLEGRO_CONFIG_ENTRY = System.IntPtr;

namespace sharpallegro5
{
    /* config.h */
    public partial class AllegroApi
    {
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_create_config();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_add_config_section(ALLEGRO_CONFIG config, string name);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_config_value(IntPtr config, string section, string key, string value);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_add_config_comment(ALLEGRO_CONFIG config, string section, string comment);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_config_value(IntPtr config, string section, string key);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_load_config_file(string filename);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_CONFIG al_load_config_file_f(ALLEGRO_FILE filename);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_save_config_file(string filename, IntPtr config);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_save_config_file_f(ALLEGRO_FILE file, ALLEGRO_CONFIG config);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_merge_config_into(ALLEGRO_CONFIG master, ALLEGRO_CONFIG add);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_CONFIG al_merge_config(ALLEGRO_CONFIG cfg1, ALLEGRO_CONFIG cfg2);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_config(IntPtr config);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_first_config_section(IntPtr config, IntPtr iterator);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_next_config_section(IntPtr iterator);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_first_config_entry(IntPtr config, string section, IntPtr iterator);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_next_config_entry(IntPtr iterator);
    }
}
