using System;

using sharpallegro5;

using ALLEGRO_PATH = System.IntPtr;

public class ex_get_path : AllegroExample
{
    static void show_path(int id, string label)
    {
        ALLEGRO_PATH path;
        string path_str;

        path = al_get_standard_path(id);
        path_str = (path != NULL) ? al_path_cstr(path, ALLEGRO_NATIVE_PATH_SEP) : "<none>";
        log_printf("{0}: {1}\n", label, path_str);
        al_destroy_path(path);
    }

    static int Main()
    {
        /* defaults to blank */
        al_set_org_name("liballeg.org");

        /* defaults to the exename, set it here to remove the .exe on windows */
        al_set_app_name("ex_get_path");

        if (!al_init())
        {
            abort_example("Could not init Allegro.\n");
        }
        open_log();

        show_path(ALLEGRO_RESOURCES_PATH, "RESOURCES_PATH");
        show_path(ALLEGRO_TEMP_PATH, "TEMP_PATH");
        show_path(ALLEGRO_USER_DATA_PATH, "USER_DATA_PATH");
        show_path(ALLEGRO_USER_SETTINGS_PATH, "USER_SETTINGS_PATH");
        show_path(ALLEGRO_USER_HOME_PATH, "USER_HOME_PATH");
        show_path(ALLEGRO_USER_DOCUMENTS_PATH, "USER_DOCUMENTS_PATH");
        show_path(ALLEGRO_EXENAME_PATH, "EXENAME_PATH");

        close_log(true);
        return 0;
    }
}