using System;
using System.Runtime.InteropServices;

using sharpallegro5;

using ALLEGRO_CONFIG = System.IntPtr;

/*
 *    Example program for the Allegro library.
 *
 *    Test config file reading and writing.
 */
public class ex_config : AllegroExample
{
    static bool passed = true;

    public static void TEST(string name, bool expr)
    {
        do
        {
            if (expr)
                log_printf(" PASS - {0}\n", name);
            else
            {
                log_printf("!FAIL - {0}\n", name);
                passed = false;
            }
        } while (false);
    }

    static int Main()
    {
        ALLEGRO_CONFIG cfg;
        string value;
        IntPtr iterator = StructureToPtr(new ALLEGRO_CONFIG_SECTION());
        IntPtr iterator2 = StructureToPtr(new ALLEGRO_CONFIG_ENTRY());

        if (!al_init())
        {
            return 1;
        }
        open_log();

        cfg = al_load_config_file("data/sample.cfg");
        if (cfg == IntPtr.Zero)
        {
            abort_example("Couldn't load data/sample.cfg\n");
            return 1;
        }

        value = al_get_config_value(cfg, null, "old_var");
        TEST("global var", !string.IsNullOrEmpty(value) && value == "old global value");

        value = al_get_config_value(cfg, "section", "old_var");
        TEST("section var", !string.IsNullOrEmpty(value) && value == "old section value");

        value = al_get_config_value(cfg, "", "mysha.xpm");
        TEST("long value", !string.IsNullOrEmpty(value) && value.Length == 1394);

        /* Test whether iterating through our whole sample.cfg returns all
         * sections and entries, in order.
         */

        value = al_get_first_config_section(cfg, iterator);
        TEST("section1", value != null && value == "");

        value = al_get_first_config_entry(cfg, value, iterator2);
        TEST("entry1", value != null && value == "old_var");

        value = al_get_next_config_entry(iterator2);
        TEST("entry2", value != null && value == "mysha.xpm");

        value = al_get_next_config_entry(iterator2);
        TEST("entry3", value == null);

        value = al_get_next_config_section(iterator);
        TEST("section2", value != null && value == "section");

        value = al_get_first_config_entry(cfg, value, iterator2);
        TEST("entry4", value != null && value == "old_var");

        value = al_get_next_config_entry(iterator2);
        TEST("entry5", value == null);

        value = al_get_next_config_section(iterator);
        TEST("section3", value != null);

        value = al_get_first_config_entry(cfg, value, iterator2);
        TEST("entry6", value!= null);

        value = al_get_next_config_entry(iterator2);
        TEST("entry7", value == null);

        value = al_get_next_config_section(iterator);
        TEST("section4", value == null);



        al_set_config_value(cfg, "", "new_var", "new value");
        al_set_config_value(cfg, "section", "old_var", "new value");

        TEST("save_config", al_save_config_file("test.cfg", cfg));

        al_destroy_config(cfg);

        close_log(true);

        return passed ? 0 : 1;
    }
}