﻿using System;
using System.Runtime.InteropServices;

using uint32_t = System.UInt32;
using size_t = System.UInt32;
using ALLEGRO_DISPLAY = System.IntPtr;

/* Type: ALLEGRO_FILECHOOSER
 */
using ALLEGRO_FILECHOOSER = System.IntPtr;

/* Type: ALLEGRO_TEXTLOG
 */
using ALLEGRO_TEXTLOG = System.IntPtr;

namespace sharpallegro5
{
    /* allegro_nativa_dialog.h */
    public partial class AllegroApi
    {
        #region SharpAllegro

        private const string allegroDialogDllName = "allegro_dialog-5.0.5-mt.dll";

        #endregion

        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_FILECHOOSER al_create_native_file_dialog(string initial_path, string title, string patterns, int mode);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_show_native_file_dialog(ALLEGRO_DISPLAY display, ALLEGRO_FILECHOOSER dialog);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_native_file_dialog_count(ALLEGRO_FILECHOOSER dialog);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_native_file_dialog_path(ALLEGRO_FILECHOOSER dialog, size_t index);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_native_file_dialog(ALLEGRO_FILECHOOSER dialog);

        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_show_native_message_box(ALLEGRO_DISPLAY display, string title, string heading, string text, string buttons, int flags);

        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_TEXTLOG al_open_native_text_log(string title, int flags);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_close_native_text_log(ALLEGRO_TEXTLOG textlog);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_append_native_text_log(ALLEGRO_TEXTLOG textlog, string format, __arglist);
        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_native_text_log_event_source(ALLEGRO_TEXTLOG textlog);

        [DllImport(allegroDialogDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint32_t al_get_allegro_native_dialog_version();

        public const int ALLEGRO_FILECHOOSER_FILE_MUST_EXIST = 1;
        public const int ALLEGRO_FILECHOOSER_SAVE = 2;
        public const int ALLEGRO_FILECHOOSER_FOLDER = 4;
        public const int ALLEGRO_FILECHOOSER_PICTURES = 8;
        public const int ALLEGRO_FILECHOOSER_SHOW_HIDDEN = 16;
        public const int ALLEGRO_FILECHOOSER_MULTIPLE = 32;

        public const int ALLEGRO_MESSAGEBOX_WARN = 1 << 0;
        public const int ALLEGRO_MESSAGEBOX_ERROR = 1 << 1;
        public const int ALLEGRO_MESSAGEBOX_OK_CANCEL = 1 << 2;
        public const int ALLEGRO_MESSAGEBOX_YES_NO = 1 << 3;
        public const int ALLEGRO_MESSAGEBOX_QUESTION = 1 << 4;

        public const int ALLEGRO_TEXTLOG_NO_CLOSE = 1 << 0;
        public const int ALLEGRO_TEXTLOG_MONOSPACE = 1 << 1;

        public const int ALLEGRO_EVENT_NATIVE_DIALOG_CLOSE = 600;
    }
}
