﻿using System;
using System.Runtime.InteropServices;

namespace sharpallegro5
{
    /* tls.h */
    public partial class AllegroApi
    {
        /* Enum: ALLEGRO_STATE_FLAGS
         */
        //enum ALLEGRO_STATE_FLAGS
        //{
        public const int ALLEGRO_STATE_NEW_DISPLAY_PARAMETERS = 0x0001;
        public const int ALLEGRO_STATE_NEW_BITMAP_PARAMETERS = 0x0002;
        public const int ALLEGRO_STATE_DISPLAY = 0x0004;
        public const int ALLEGRO_STATE_TARGET_BITMAP = 0x0008;
        public const int ALLEGRO_STATE_BLENDER = 0x0010;
        public const int ALLEGRO_STATE_NEW_FILE_INTERFACE = 0x0020;
        public const int ALLEGRO_STATE_TRANSFORM = 0x0040;

        public const int ALLEGRO_STATE_BITMAP = ALLEGRO_STATE_TARGET_BITMAP + ALLEGRO_STATE_NEW_BITMAP_PARAMETERS;

        public const int ALLEGRO_STATE_ALL = 0xffff;
        //};


        /* Type: ALLEGRO_STATE
         */
        public unsafe struct ALLEGRO_STATE
        {
            /* Internally, a thread_local_state structure is placed here. */
            fixed char _tls[1024];
        };

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_store_state(ref ALLEGRO_STATE state, int flags);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_restore_state(ref ALLEGRO_STATE state);
    }
}
