﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_BITMAP = System.IntPtr;

/* Type: ALLEGRO_DISPLAY
 */
using ALLEGRO_DISPLAY = System.IntPtr;

namespace sharpallegro5
{
    public enum ALLEGRO_DISPLAY_ORIENTATION
    {
        ALLEGRO_DISPLAY_ORIENTATION_0_DEGREES,
        ALLEGRO_DISPLAY_ORIENTATION_90_DEGREES,
        ALLEGRO_DISPLAY_ORIENTATION_180_DEGREES,
        ALLEGRO_DISPLAY_ORIENTATION_270_DEGREES,
        ALLEGRO_DISPLAY_ORIENTATION_FACE_UP,
        ALLEGRO_DISPLAY_ORIENTATION_FACE_DOWN
    }

    public partial class AllegroApi
    {
        /* Possible bit combinations for the flags parameter of al_create_display. */
        public const int ALLEGRO_WINDOWED = 1 << 0;
        public const int ALLEGRO_FULLSCREEN = 1 << 1;
        public const int ALLEGRO_OPENGL = 1 << 2;
        public const int ALLEGRO_DIRECT3D_INTERNAL = 1 << 3;
        public const int ALLEGRO_RESIZABLE = 1 << 4;
        public const int ALLEGRO_NOFRAME = 1 << 5;
        public const int ALLEGRO_GENERATE_EXPOSE_EVENTS = 1 << 6;
        public const int ALLEGRO_OPENGL_3_0 = 1 << 7;
        public const int ALLEGRO_OPENGL_FORWARD_COMPATIBLE = 1 << 8;
        public const int ALLEGRO_FULLSCREEN_WINDOW = 1 << 9;
        public const int ALLEGRO_MINIMIZED = 1 << 10;

        /* Possible parameters for al_set_display_option.
         * Make sure to update ALLEGRO_EXTRA_DISPLAY_SETTINGS if you modify
         * anything here.
         */
        //public enum ALLEGRO_DISPLAY_OPTIONS
        //{
        public const int ALLEGRO_RED_SIZE = 0;
        public const int ALLEGRO_GREEN_SIZE = 1;
        public const int ALLEGRO_BLUE_SIZE = 2;
        public const int ALLEGRO_ALPHA_SIZE = 3;
        public const int ALLEGRO_RED_SHIFT = 4;
        public const int ALLEGRO_GREEN_SHIFT = 5;
        public const int ALLEGRO_BLUE_SHIFT = 6;
        public const int ALLEGRO_ALPHA_SHIFT = 7;
        public const int ALLEGRO_ACC_RED_SIZE = 8;
        public const int ALLEGRO_ACC_GREEN_SIZE = 9;
        public const int ALLEGRO_ACC_BLUE_SIZE = 10;
        public const int ALLEGRO_ACC_ALPHA_SIZE = 11;
        public const int ALLEGRO_STEREO = 12;
        public const int ALLEGRO_AUX_BUFFERS = 13;
        public const int ALLEGRO_COLOR_SIZE = 14;
        public const int ALLEGRO_DEPTH_SIZE = 15;
        public const int ALLEGRO_STENCIL_SIZE = 16;
        public const int ALLEGRO_SAMPLE_BUFFERS = 17;
        public const int ALLEGRO_SAMPLES = 18;
        public const int ALLEGRO_RENDER_METHOD = 19;
        public const int ALLEGRO_FLOAT_COLOR = 20;
        public const int ALLEGRO_FLOAT_DEPTH = 21;
        public const int ALLEGRO_SINGLE_BUFFER = 22;
        public const int ALLEGRO_SWAP_METHOD = 23;
        public const int ALLEGRO_COMPATIBLE_DISPLAY = 24;
        public const int ALLEGRO_UPDATE_DISPLAY_REGION = 25;
        public const int ALLEGRO_VSYNC = 26;
        public const int ALLEGRO_MAX_BITMAP_SIZE = 27;
        public const int ALLEGRO_SUPPORT_NPOT_BITMAP = 28;
        public const int ALLEGRO_CAN_DRAW_INTO_BITMAP = 29;
        public const int ALLEGRO_SUPPORT_SEPARATE_ALPHA = 30;
        public const int ALLEGRO_DISPLAY_OPTIONS_COUNT = 31;
        //};

        public const int ALLEGRO_DONTCARE = 0;
        public const int ALLEGRO_REQUIRE = 1;
        public const int ALLEGRO_SUGGEST = 2;

        /* Type: ALLEGRO_DISPLAY_MODE
         */
        [StructLayout(LayoutKind.Explicit)]
        public struct ALLEGRO_DISPLAY_MODE
        {
            [FieldOffset(0)]
            public int width;
            [FieldOffset(4)]
            public int height;
            [FieldOffset(8)]
            public int format;
            [FieldOffset(12)]
            public int refresh_rate;
        }


        /* Type: ALLEGRO_MONITOR_INFO
         */
        [StructLayout(LayoutKind.Explicit)]
        public struct ALLEGRO_MONITOR_INFO
        {
            [FieldOffset(0)]
            public int x1;
            [FieldOffset(4)]
            public int y1;
            [FieldOffset(8)]
            public int x2;
            [FieldOffset(12)]
            public int y2;
        }


        public const int ALLEGRO_DEFAULT_DISPLAY_ADAPTER = -1;

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_new_display_refresh_rate(int refresh_rate);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_new_display_flags(int flags);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_new_display_refresh_rate();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_new_display_flags();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_width(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_height(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_format(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_refresh_rate(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_flags(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_toggle_display_flag(ALLEGRO_DISPLAY display, int flag, bool onoff);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_DISPLAY al_create_display(int w, int h);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_display(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_DISPLAY al_get_current_display();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_target_bitmap(ALLEGRO_BITMAP bitmap);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_target_backbuffer(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_backbuffer(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_BITMAP al_get_target_bitmap();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_acknowledge_resize(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_resize_display(ALLEGRO_DISPLAY display, int width, int height);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_flip_display();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_update_display_region(int x, int y, int width, int height);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_is_compatible_bitmap(ALLEGRO_BITMAP bitmap);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_num_display_modes();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_display_mode(int index, ref ALLEGRO_DISPLAY_MODE mode);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_wait_for_vsync();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_display_event_source(ALLEGRO_DISPLAY display);

        /* Primitives */
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_clear_to_color(ALLEGRO_COLOR color);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_pixel(float x, float y, ALLEGRO_COLOR color);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_display_icon(ALLEGRO_DISPLAY display, ALLEGRO_BITMAP icon);

        /* Stuff for multihead/window management */
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_num_video_adapters();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_get_monitor_info(int adapter, ref ALLEGRO_MONITOR_INFO info);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_new_display_adapter();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_new_display_adapter(int adapter);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_new_window_position(int x, int y);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_new_window_position(ref int x, ref int y);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_window_position(ALLEGRO_DISPLAY display, int x, int y);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_window_position(ALLEGRO_DISPLAY display, ref int x, ref int y);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_window_title(ALLEGRO_DISPLAY display, string title);

        /* Defined in display_settings.c */
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_new_display_option(int option, int value, int importance);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_new_display_option(int option, ref int importance);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_reset_new_display_options();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_display_option(ALLEGRO_DISPLAY display, int option);

        /*Deferred drawing*/
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_hold_bitmap_drawing(bool hold);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_is_bitmap_drawing_held();
    }
}
