﻿using System;
using System.Runtime.InteropServices;

namespace sharpallegro5
{
    /* base.h */
    public partial class AllegroApi
    {
        #region SharpAllegro

        private const string allegroDllName = "allegro-5.0.5-mt.dll";

        public delegate int user_main(int argc, string[] argv);

        /* int atexit ( void ( * function ) (void) ); */
        public delegate void function();
        public static function atexit = delegate() {};

        public static IntPtr NULL = IntPtr.Zero;

        #endregion

        public const int ALLEGRO_VERSION = 5;
        public const int ALLEGRO_SUB_VERSION = 0;
        public const int ALLEGRO_WIP_VERSION = 5;
        /* Not sure we need it, but since ALLEGRO_VERSION_STR contains it:
         * 0 = SVN
         * 1 = first release
         * 2... = hotfixes?
         *
         * Note x.y.z (= x.y.z.0) has release number 1, and x.y.z.1 has release
         * number 2, just to confuse you.
         */
        public const int ALLEGRO_RELEASE_NUMBER = 1;

        public const string ALLEGRO_VERSION_STR = "5.0.5";
        public const string ALLEGRO_DATE_STR = "2011";
        public const int ALLEGRO_DATE = 20110814;    /* yyyymmdd */

        public static int ALLEGRO_VERSION_INT = ((ALLEGRO_VERSION << 24) | (ALLEGRO_SUB_VERSION << 16) | (ALLEGRO_WIP_VERSION << 8) | ALLEGRO_RELEASE_NUMBER);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint al_get_allegro_version();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_run_main(int argc, [MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0, ArraySubType = UnmanagedType.LPStr)] string[] argv, user_main user_main);


        /*******************************************/
        /************ Some global stuff ************/
        /*******************************************/

        /* Type: ALLEGRO_PI
         */
        public const double ALLEGRO_PI = 3.14159265358979323846;

        public static int AL_ID(int a, int b, int c, int d) { return (((a) << 24) | ((b) << 16) | ((c) << 8) | (d)); }

        struct _AL_DRIVER_INFO      /* info about a hardware driver */
        {
            int id;                          /* integer ID */
            IntPtr driver;                    /* the driver structure */
            int autodetect;                  /* set to allow autodetection */
        }
    }
}
