﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_SYSTEM = System.IntPtr;
using ALLEGRO_CONFIG = System.IntPtr;
using ALLEGRO_PATH = System.IntPtr;

namespace sharpallegro5
{
    /* system.h */
    public partial class AllegroApi
    {
        //typedef struct ALLEGRO_SYSTEM ALLEGRO_SYSTEM;

        /* Function: al_init
         */
        public static bool al_init() { return al_install_system(ALLEGRO_VERSION_INT, atexit); }

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_install_system(int version, function atexit_ptr);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_uninstall_system();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_is_system_installed();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_SYSTEM al_get_system_driver();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_CONFIG al_get_system_config();


        public const int ALLEGRO_RESOURCES_PATH = 0;
        public const int ALLEGRO_TEMP_PATH = 1;
        public const int ALLEGRO_USER_DATA_PATH = 2;
        public const int ALLEGRO_USER_HOME_PATH = 3;
        public const int ALLEGRO_USER_SETTINGS_PATH = 4;
        public const int ALLEGRO_USER_DOCUMENTS_PATH = 5;
        public const int ALLEGRO_EXENAME_PATH = 6;
        public const int ALLEGRO_LAST_PATH = 7; // must be last

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_standard_path(int id);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_org_name(string org_name);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_app_name(string app_name);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_org_name();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_get_app_name();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_inhibit_screensaver(bool inhibit);
    }
}
