﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_BITMAP = System.IntPtr;
using uint32_t = System.UInt32;

/* Type: ALLEGRO_FONT
*/
using ALLEGRO_FONT = System.IntPtr;
using ALLEGRO_FONT_VTABLE = System.IntPtr;

namespace sharpallegro5
{
    /* allegro_font.h */
    public partial class AllegroApi
    {
        #region SharpAllegro

        private const string allegroFontDllName = "allegro_font-5.0.5-mt.dll";

        #endregion

        //public struct ALLEGRO_FONT
        //{
        //    IntPtr data;
        //    int height;
        //    ALLEGRO_FONT_VTABLE vtable;
        //};

        /* text- and font-related stuff */
        //struct ALLEGRO_FONT_VTABLE
        //{
        //   ALLEGRO_FONT_METHOD(int, font_height, (const ALLEGRO_FONT *f));
        //   ALLEGRO_FONT_METHOD(int, font_ascent, (const ALLEGRO_FONT *f));
        //   ALLEGRO_FONT_METHOD(int, font_descent, (const ALLEGRO_FONT *f));
        //   ALLEGRO_FONT_METHOD(int, char_length, (const ALLEGRO_FONT *f, int ch));
        //   ALLEGRO_FONT_METHOD(int, text_length, (const ALLEGRO_FONT *f, const ALLEGRO_USTR *text));
        //   ALLEGRO_FONT_METHOD(int, render_char, (const ALLEGRO_FONT *f, ALLEGRO_COLOR color, int ch, float x, float y));
        //   ALLEGRO_FONT_METHOD(int, render, (const ALLEGRO_FONT *f, ALLEGRO_COLOR color, const ALLEGRO_USTR *text, float x, float y));
        //   ALLEGRO_FONT_METHOD(void, destroy, (ALLEGRO_FONT *f));
        //   ALLEGRO_FONT_METHOD(void, get_text_dimensions, (const ALLEGRO_FONT *f,
        //      const ALLEGRO_USTR *text, int *bbx, int *bby, int *bbw, int *bbh));
        //};

        public const int ALLEGRO_ALIGN_LEFT = 0;
        public const int ALLEGRO_ALIGN_CENTRE = 1;
        public const int ALLEGRO_ALIGN_RIGHT = 2;

        //        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        //public static extern bool al_register_font_loader(string ext, ALLEGRO_FONT *(*load)(const char *filename, int size, int flags));
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_FONT al_load_bitmap_font(string filename);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_load_font(string filename, int size, int flags);

        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_FONT al_grab_font_from_bitmap(ALLEGRO_BITMAP bmp, int n, int[] ranges);

        //void al_draw_ustr(const ALLEGRO_FONT *font, ALLEGRO_COLOR color, float x, float y, int flags, const ALLEGRO_USTR *ustr)
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_ustr(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x, float y, int flags, IntPtr ustr);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_text(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x, float y, int flags, string text,  __arglist);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_justified_text(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x1, float x2, float y, float diff, int flags, string text);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_justified_ustr(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x1, float x2, float y, float diff, int flags, string text);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_textf(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x, float y, int flags, string text, __arglist);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_draw_justified_textf(ALLEGRO_FONT font, ALLEGRO_COLOR color, float x1, float x2, float y, float diff, int flags, string format, params object[] arg);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_text_width(ALLEGRO_FONT f, string str);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_ustr_width(ALLEGRO_FONT f, string ustr);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_font_line_height(ALLEGRO_FONT f);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_font_ascent(ALLEGRO_FONT f);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_font_descent(ALLEGRO_FONT f);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_font(ALLEGRO_FONT f);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_ustr_dimensions(ALLEGRO_FONT f, string text, ref int bbx, ref int bby, ref int bbw, ref int bbh);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_text_dimensions(ALLEGRO_FONT f, string text, ref int bbx, ref int bby, ref int bbw, ref int bbh);
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_init_font_addon();
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_shutdown_font_addon();
        [DllImport(allegroFontDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint32_t al_get_allegro_font_version();
    }
}
