﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_DISPLAY = System.IntPtr;

using ALLEGRO_KEYBOARD = System.IntPtr;

namespace sharpallegro5
{
    /* keyboard.h */
    public partial class AllegroApi
    {
        /* Type: ALLEGRO_KEYBOARD_STATE
         */
        public unsafe struct ALLEGRO_KEYBOARD_STATE
        {
            public ALLEGRO_DISPLAY display;  /* public */
            /* internal */
            fixed uint __key_down__internal__[(ALLEGRO_KEY_MAX + 31) / 32];
        };


        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_is_keyboard_installed();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_install_keyboard();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_uninstall_keyboard();

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_keyboard_leds(int leds);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_keycode_to_name(int keycode);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_keyboard_state(ref ALLEGRO_KEYBOARD_STATE ret_state);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_key_down(ref ALLEGRO_KEYBOARD_STATE state, int keycode);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_keyboard_event_source();


        /* TODO: use the config system */
        public static bool _al_three_finger_flag;
        public static bool _al_key_led_flag;
    }
}
