﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_BITMAP = System.IntPtr;
using ALLEGRO_FILE = System.IntPtr;

namespace sharpallegro5
{
    /* bitmap_io.h */
    public partial class AllegroApi
    {
        public delegate ALLEGRO_BITMAP ALLEGRO_IIO_LOADER_FUNCTION(string filename);
        public delegate ALLEGRO_BITMAP ALLEGRO_IIO_FS_LOADER_FUNCTION(ALLEGRO_FILE fp);
        public delegate ALLEGRO_BITMAP ALLEGRO_IIO_SAVER_FUNCTION(string filename, ALLEGRO_BITMAP bitmap);
        public delegate ALLEGRO_BITMAP ALLEGRO_IIO_FS_SAVER_FUNCTION(ALLEGRO_FILE fp, ALLEGRO_BITMAP bitmap);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_register_bitmap_loader(string ext, ALLEGRO_IIO_LOADER_FUNCTION loader);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_register_bitmap_saver(string ext, ALLEGRO_IIO_SAVER_FUNCTION saver);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_register_bitmap_loader_f(string ext, ALLEGRO_IIO_FS_LOADER_FUNCTION fs_loader);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_register_bitmap_saver_f(string ext, ALLEGRO_IIO_FS_SAVER_FUNCTION fs_saver);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_BITMAP al_load_bitmap(string filename);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_BITMAP al_load_bitmap_f(ALLEGRO_FILE fp, string ident);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_save_bitmap(string filename, ALLEGRO_BITMAP bitmap);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_save_bitmap_f(ALLEGRO_FILE fp, string ident, ALLEGRO_BITMAP bitmap);
    }
}
