using System;

using sharpallegro5;

public class ex_monitorinfo : AllegroExample
{
    static int Main()
    {
        ALLEGRO_MONITOR_INFO info = new ALLEGRO_MONITOR_INFO();
        int num_adapters;
        int i, j;

        if (!al_init())
        {
            abort_example("Could not init Allegro.\n");
            return 1;
        }

        open_log();

        num_adapters = al_get_num_video_adapters();

        log_printf("{0} adapters found...\n", num_adapters);

        for (i = 0; i < num_adapters; i++)
        {
            al_get_monitor_info(i, ref info);
            log_printf("Adapter {0}: ", i);
            log_printf("({0}, {1}) - ({2}, {3})\n", info.x1, info.y1, info.x2, info.y2);
            al_set_new_display_adapter(i);
            log_printf("   Available fullscreen display modes:\n");
            for (j = 0; j < al_get_num_display_modes(); j++)
            {
                ALLEGRO_DISPLAY_MODE mode = new ALLEGRO_DISPLAY_MODE();

                al_get_display_mode(j, ref mode);

                log_printf("   Mode {0,3}: {1,4} x {2,4}, {3} Hz\n",
                   j, mode.width, mode.height, mode.refresh_rate);
            }
        }

        close_log(true);

        return 0;
    }
}