﻿using System;
using System.Runtime.InteropServices;

using int64_t = System.Int64;

/* Type: ALLEGRO_TIMER
 */
using ALLEGRO_TIMER = System.IntPtr;

namespace sharpallegro5
{
    /* timer.h */
    public partial class AllegroApi
    {
        /* Function: ALLEGRO_USECS_TO_SECS
         */
        public float ALLEGRO_USECS_TO_SECS(float x) { return (float)((x) / 1000000.0); }

        /* Function: ALLEGRO_MSECS_TO_SECS
         */
        public float ALLEGRO_MSECS_TO_SECS(float x) { return (float)((x) / 1000.0); }

        /* Function: ALLEGRO_BPS_TO_SECS
         */
        public float ALLEGRO_BPS_TO_SECS(float x) { return (float)(1.0 / (x)); }

        /* Function: ALLEGRO_BPM_TO_SECS
         */
        public static float ALLEGRO_BPM_TO_SECS(float x) { return (float)(60.0 / (x)); }




        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_TIMER al_create_timer(double speed_secs);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_timer(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_start_timer(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_stop_timer(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_get_timer_started(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern double al_get_timer_speed(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_timer_speed(ALLEGRO_TIMER timer, double speed_secs);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int64_t al_get_timer_count(ALLEGRO_TIMER timer);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_set_timer_count(ALLEGRO_TIMER timer, int64_t count);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_add_timer_count(ALLEGRO_TIMER timer, int64_t diff);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_timer_event_source(ALLEGRO_TIMER timer);
    }
}
