﻿using System;
using System.Runtime.InteropServices;

using uint32_t = System.UInt32;

namespace sharpallegro5
{
    /* allegro_color.h */
    public partial class AllegroApi
    {
        #region SharpAllegro

        private const string allegroColorDllName = "allegro_color-5.0.5-mt.dll";

        #endregion

        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint32_t al_get_allegro_color_version();

        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_hsv_to_rgb(float hue, float saturation, float value, ref float red, ref float green, ref float blue);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_rgb_to_hsl(float red, float green, float blue, ref float hue, ref float saturation, ref float lightness);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_rgb_to_hsv(float red, float green, float blue, ref float hue, ref float saturation, ref float value);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_hsl_to_rgb(float hue, float saturation, float lightness, ref float red, ref float green, ref float blue);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_color_name_to_rgb(string name, ref float r, ref float g, ref float b);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern string al_color_rgb_to_name(float r, float g, float b);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_cmyk_to_rgb(float cyan, float magenta, float yellow, float key, ref float red, ref float green, ref float blue);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_rgb_to_cmyk(float red, float green, float blue, ref float cyan, ref float magenta, ref float yellow, ref float key);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_yuv_to_rgb(float y, float u, float v, ref float red, ref float green, ref float blue);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_rgb_to_yuv(float red, float green, float blue, ref float y, ref float u, ref float v);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_rgb_to_html(float red, float green, float blue, string @string);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_color_html_to_rgb(string @string, ref float red, ref float green, ref float blue);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_yuv(float y, float u, float v);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_cmyk(float c, float m, float y, float k);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_hsl(float h, float s, float l);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_hsv(float h, float s, float v);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_name(string name);
        [DllImport(allegroColorDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_COLOR al_color_html(string @string);
    }
}
