using System;

using sharpallegro5;

using ALLEGRO_DISPLAY = System.IntPtr;
using ALLEGRO_BITMAP = System.IntPtr;

public class ex_mouse : AllegroExample
{
    private static int NUM_BUTTONS = 3;

    static void draw_mouse_button(int but, bool down)
    {
        int[] offset = { 0, 70, 35 };
        ALLEGRO_COLOR grey;
        ALLEGRO_COLOR black;
        int x;
        int y;

        x = 400 + offset[but - 1];
        y = 130;

        grey = al_map_rgb(0xe0, 0xe0, 0xe0);
        black = al_map_rgb(0, 0, 0);

        al_draw_filled_rectangle(x, y, x + 27, y + 42, grey);
        al_draw_rectangle((float)(x + 0.5), (float)(y + 0.5), (float)(x + 26.5), (float)(y + 41.5), black, 0);
        if (down)
        {
            al_draw_filled_rectangle(x + 2, y + 2, x + 25, y + 40, black);
        }
    }

    static int Main()
    {
        ALLEGRO_DISPLAY display;
        ALLEGRO_BITMAP cursor;
        ALLEGRO_MOUSE_STATE msestate = new ALLEGRO_MOUSE_STATE();
        ALLEGRO_KEYBOARD_STATE kbdstate = new ALLEGRO_KEYBOARD_STATE();
        int i;

        if (!al_init())
        {
            abort_example("Could not init Allegro.\n");
            return 1;
        }

        al_init_primitives_addon();
        al_install_mouse();
        al_install_keyboard();
        al_init_image_addon();

        display = al_create_display(640, 480);
        //if (!display)
        if (display == IntPtr.Zero)
        {
            abort_example("Error creating display\n");
            return 1;
        }

        al_hide_mouse_cursor(display);

        cursor = al_load_bitmap("data/cursor.tga");
        //if (!cursor)
        if (cursor == IntPtr.Zero)
        {
            abort_example("Error loading cursor.tga\n");
            return 1;
        }

        do
        {
            al_get_mouse_state(ref msestate);
            al_get_keyboard_state(ref kbdstate);

            al_clear_to_color(al_map_rgb(0xff, 0xff, 0xc0));
            for (i = 1; i <= NUM_BUTTONS; i++)
            {
                draw_mouse_button(i, al_mouse_button_down(ref msestate, i));
            }
            al_draw_bitmap(cursor, msestate.x, msestate.y, 0);
            al_flip_display();

            al_rest(0.005);
        } while (!al_key_down(ref kbdstate, ALLEGRO_KEY_ESCAPE));

        return 0;
    }
}