using System;

using sharpallegro5;

using ALLEGRO_DISPLAY = System.IntPtr;

/*
 *    Example program for the Allegro library.
 *
 *    This program tests if the ALLEGRO_MOUSE_STATE `display' field
 *    is set correctly.
 */
public class ex_mouse_focus : AllegroExample
{
    static ALLEGRO_DISPLAY display1;
    static ALLEGRO_DISPLAY display2;

    static void redraw(ALLEGRO_COLOR color1, ALLEGRO_COLOR color2)
    {
        al_set_target_backbuffer(display1);
        al_clear_to_color(color1);
        al_flip_display();

        al_set_target_backbuffer(display2);
        al_clear_to_color(color2);
        al_flip_display();
    }

    static int Main()
    {
        ALLEGRO_COLOR black;
        ALLEGRO_COLOR red;
        ALLEGRO_MOUSE_STATE mst0;
        ALLEGRO_MOUSE_STATE mst = new ALLEGRO_MOUSE_STATE();
        ALLEGRO_KEYBOARD_STATE kst = new ALLEGRO_KEYBOARD_STATE();

        if (!al_init())
        {
            abort_example("Couldn't initialise Allegro.\n");
            return 1;
        }
        if (!al_install_mouse())
        {
            abort_example("Couldn't install mouse.\n");
            return 1;
        }
        if (!al_install_keyboard())
        {
            abort_example("Couldn't install keyboard.\n");
            return 1;
        }

        display1 = al_create_display(300, 300);
        display2 = al_create_display(300, 300);
        if (display1 == IntPtr.Zero || display2 == IntPtr.Zero)
        {
            abort_example("Couldn't open displays.\n");
            al_destroy_display(display1);
            al_destroy_display(display2);
            return 1;
        }

        open_log();
        log_printf("Move the mouse cursor over the displays\n");

        black = al_map_rgb(0, 0, 0);
        red = al_map_rgb(255, 0, 0);

        mst0 = new ALLEGRO_MOUSE_STATE();

        while (true)
        {
            al_get_mouse_state(ref mst);
            if (mst.display != mst0.display ||
                  mst.x != mst0.x ||
                  mst.y != mst0.y)
            {
                if (mst.display == NULL)
                    log_printf("Outside either display\n");
                else if (mst.display == display1)
                    log_printf("In display 1, x = {0}, y = {1}\n", mst.x, mst.y);
                else if (mst.display == display2)
                    log_printf("In display 2, x = {0}, y = {1}\n", mst.x, mst.y);
                else
                {
                    log_printf("Unknown display = {0}, x = {1}, y = {2}\n", mst.display,
                       mst.x, mst.y);
                }
                mst0 = mst;
            }

            if (mst.display == display1)
            {
                redraw(red, black);
            }
            else if (mst.display == display2)
            {
                redraw(black, red);
            }
            else
            {
                redraw(black, black);
            }

            al_rest(0.1);

            al_get_keyboard_state(ref kst);
            if (al_key_down(ref kst, ALLEGRO_KEY_ESCAPE))
            {
                break;
            }
        }

        close_log(false);

        return 0;
    }
}