﻿using System;
using System.Runtime.InteropServices;

using uint32_t = System.UInt32;

using ALLEGRO_FONT = System.IntPtr;
using ALLEGRO_FILE = System.IntPtr;

namespace sharpallegro5
{
    /* allegro_font.h */
    public partial class AllegroApi
    {
        #region SharpAllegro

        private const string allegroTtfDllName = "allegro_ttf-5.0.5-mt.dll";

        #endregion

        public const int ALLEGRO_TTF_NO_KERNING = 1;
        public const int ALLEGRO_TTF_MONOCHROME = 2;

        [DllImport(allegroTtfDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_FONT al_load_ttf_font(string filename, int size, int flags);
        [DllImport(allegroTtfDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_FONT al_load_ttf_font_f(ALLEGRO_FILE file, string filename, int size, int flags);
        [DllImport(allegroTtfDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_init_ttf_addon();
        [DllImport(allegroTtfDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_shutdown_ttf_addon();
        [DllImport(allegroTtfDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint32_t al_get_allegro_ttf_version();
    }
}
