﻿using System;
using System.Runtime.InteropServices;

using ALLEGRO_DISPLAY = System.IntPtr;
using ALLEGRO_MOUSE = System.IntPtr;
using ALLEGRO_BITMAP = System.IntPtr;

/* Mouse cursors */
using ALLEGRO_MOUSE_CURSOR = System.IntPtr;

namespace sharpallegro5
{
    public partial class AllegroApi
    {
        /* Allow up to four extra axes for future expansion. */
        public const int ALLEGRO_MOUSE_MAX_EXTRA_AXES = 4;



        /* Type: ALLEGRO_MOUSE_STATE
         */
        public unsafe struct ALLEGRO_MOUSE_STATE
        {
            /* (x, y) Primary mouse position
             * (z) Mouse wheel position (1D 'wheel'), or,
             * (w, z) Mouse wheel position (2D 'ball')
             * display - the display the mouse is on (coordinates are relative to this)
             * pressure - the pressure appleid to the mouse (for stylus/tablet)
             */
            public int x;
            public int y;
            public int z;
            public int w;
            public fixed int more_axes[ALLEGRO_MOUSE_MAX_EXTRA_AXES];
            public int buttons;
            public float pressure;
            public ALLEGRO_DISPLAY display;
        };


        //public enum ALLEGRO_SYSTEM_MOUSE_CURSOR
        //{
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_NONE = 0;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_DEFAULT = 1;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_ARROW = 2;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_BUSY = 3;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_QUESTION = 4;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_EDIT = 5;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_MOVE = 6;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_N = 7;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_W = 8;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_S = 9;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_E = 10;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_NW = 11;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_SW = 12;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_SE = 13;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_NE = 14;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_PROGRESS = 15;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_PRECISION = 16;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_LINK = 17;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_ALT_SELECT = 18;
        public const int ALLEGRO_SYSTEM_MOUSE_CURSOR_UNAVAILABLE = 19;
        public const int ALLEGRO_NUM_SYSTEM_MOUSE_CURSORS = 20;
        //};



        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_is_mouse_installed();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_install_mouse();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_uninstall_mouse();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint al_get_mouse_num_buttons();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern uint al_get_mouse_num_axes();
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_mouse_xy(ALLEGRO_DISPLAY display, int x, int y);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_mouse_z(int z);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_mouse_w(int w);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_mouse_axis(int axis, int value);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_get_mouse_state(ref ALLEGRO_MOUSE_STATE ret_state);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_mouse_button_down(ref ALLEGRO_MOUSE_STATE state, int button);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern int al_get_mouse_state_axis(ALLEGRO_MOUSE_STATE state, int axis);

        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr al_get_mouse_event_source();

        /*
         * Cursors:
         *
         * This will probably become part of the display API.  It provides for
         * hardware cursors only; software cursors may or may not be provided
         * for later (it would need significant cooperation from the display
         * API).
         */
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern ALLEGRO_MOUSE_CURSOR al_create_mouse_cursor(ALLEGRO_BITMAP sprite, int xfocus, int yfocus);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern void al_destroy_mouse_cursor(ALLEGRO_MOUSE_CURSOR cursor);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_mouse_cursor(ALLEGRO_DISPLAY display, ALLEGRO_MOUSE_CURSOR cursor);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_set_system_mouse_cursor(ALLEGRO_DISPLAY display, int cursor_id);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_show_mouse_cursor(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_hide_mouse_cursor(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_get_mouse_cursor_position(ref int ret_x, ref int ret_y);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_grab_mouse(ALLEGRO_DISPLAY display);
        [DllImport(allegroDllName, CallingConvention = CallingConvention.Cdecl)]
        public static extern bool al_ungrab_mouse();
    }
}
