﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace sharpallegro5
{
    public class CPtr<T>
    {
        private IntPtr pointer;

        public CPtr(IntPtr pointer)
        {
            this.pointer = pointer;
        }

        public static implicit operator IntPtr(CPtr<T> cptr)
        {
            return cptr.pointer;
        }

        public static implicit operator CPtr<T>(IntPtr ptr)
        {
            return new CPtr<T>(ptr);
        }

        public static explicit operator T(CPtr<T> cptr)
        {
            return (T)Marshal.PtrToStructure(cptr.pointer, typeof(T));
        }

        public T ToStructure()
        {
            return (T)this;
        }

        public CPtr<T> Offset(int offset)
        {
            pointer = new IntPtr(pointer.ToInt64() + offset);
            return this;
        }

        public static CPtr<T> operator +(CPtr<T> pointer, int offset)
        {
            return pointer.Offset(offset);
        }

        //        public static void operator =(CPtr<T> pointer, int offset)
        //{
        //    return pointer.Offset(offset);
        //}

        public CPtr<T> this[int index]
        {
            get
            {
                return new CPtr<T>(pointer).Offset(index);
            }
        }

        //public static void operator =(CPtr<T> pointer, int value)
        //{

        //}
    }
}
