using System;
using System.Runtime.InteropServices;

using sharpallegro5;

using ALLEGRO_BITMAP = System.IntPtr;
using ALLEGRO_FONT = System.IntPtr;
using ALLEGRO_EVENT_QUEUE = System.IntPtr;
using ALLEGRO_DISPLAY = System.IntPtr;
using ALLEGRO_TIMER = System.IntPtr;

/* An example demonstrating different blending modes.
 */
public class ex_blit : AllegroExample
{
    unsafe struct Example
    {
        public ALLEGRO_BITMAP pattern;
        public ALLEGRO_FONT font;
        public ALLEGRO_EVENT_QUEUE queue;
        public ALLEGRO_COLOR background, text, white;

        public double[] timer, counter;
        public int FPS;
        public float text_x, text_y;

        public Example(int size)
        {
            pattern = IntPtr.Zero;
            font = IntPtr.Zero;
            queue = IntPtr.Zero;
            background = new ALLEGRO_COLOR();
            text = new ALLEGRO_COLOR();
            white = new ALLEGRO_COLOR();
            timer = new double[size];
            counter = new double[size];
            FPS = 0;
            text_x = 0;
            text_y = 0;
        }
    };
    static Example ex = new Example(4);

    static ALLEGRO_BITMAP example_bitmap(int w, int h)
    {
        int i, j;
        float mx = w * 0.5f;
        float my = h * 0.5f;
        ALLEGRO_STATE state;
        ALLEGRO_LOCKED_REGION @lock;
        ALLEGRO_BITMAP pattern = al_create_bitmap(w, h);
        al_store_state(ref state, ALLEGRO_STATE_TARGET_BITMAP);
        al_set_target_bitmap(pattern);
        @lock = al_lock_bitmap(pattern, ALLEGRO_PIXEL_FORMAT_ANY, ALLEGRO_LOCK_WRITEONLY);
        for (i = 0; i < w; i++)
        {
            for (j = 0; j < h; j++)
            {
                float a = (float)Math.Atan2(i - mx, j - my);
                float d = (float)Math.Sqrt(Math.Pow(i - mx, 2) + Math.Pow(j - my, 2));
                float sat = (float)Math.Pow(1.0 - 1 / (1 + d * 0.1), 5);
                float hue = (float)(3 * a * 180 / ALLEGRO_PI);
                hue = (float)(hue / 360 - Math.Floor(hue / 360)) * 360;
                al_put_pixel(i, j, al_color_hsv(hue, sat, 1));
            }
        }
        al_put_pixel(0, 0, al_map_rgb(0, 0, 0));
        al_unlock_bitmap(pattern);
        al_restore_state(ref state);
        return pattern;
    }

    static void set_xy(float x, float y)
    {
        ex.text_x = x;
        ex.text_y = y;
    }

    static void get_xy(ref float x, ref float y)
    {
        x = ex.text_x;
        y = ex.text_y;
    }

    static void print(string format, params object[] arg)
    {
        string message;
        int th = al_get_font_line_height(ex.font);
        message = string.Format(format, arg);
        al_set_blender(ALLEGRO_ADD, ALLEGRO_ONE, ALLEGRO_INVERSE_ALPHA);
        al_draw_textf(ex.font, ex.text, ex.text_x, ex.text_y, 0, "%s", __arglist(message));
        ex.text_y += th;
    }

    static void start_timer(int i)
    {
        ex.timer[i] -= al_get_time();
        ex.counter[i]++;
    }

    static void stop_timer(int i)
    {
        ex.timer[i] += al_get_time();
    }

    static double get_fps(int i)
    {
        if (ex.timer[i] == 0)
            return 0;
        return ex.counter[i] / ex.timer[i];
    }

    static void draw()
    {
        float x = 0f, y = 0f;
        int iw = al_get_bitmap_width(ex.pattern);
        int ih = al_get_bitmap_height(ex.pattern);
        ALLEGRO_BITMAP screen, temp;
        ALLEGRO_LOCKED_REGION @lock;
        IntPtr data;
        int size, i, format;

        al_set_blender(ALLEGRO_ADD, ALLEGRO_ONE, ALLEGRO_ZERO);

        al_clear_to_color(ex.background);

        screen = al_get_target_bitmap();

        set_xy(8, 8);

        /* Test 1. */
        /* Disabled: drawing to same bitmap is not supported. */
        /*
        print("Screen -> Screen (%.1f fps)", get_fps(0));
        get_xy(&x, &y);
        al_draw_bitmap(ex.pattern, x, y, 0);

        start_timer(0);
        al_draw_bitmap_region(screen, x, y, iw, ih, x + 8 + iw, y, 0);
        stop_timer(0);
        set_xy(x, y + ih);
        */

        /* Test 2. */
        print("Screen -> Bitmap -> Screen (%.1f fps)", get_fps(1));
        get_xy(ref x, ref y);
        //al_draw_bitmap(ex.pattern, x, y, 0);

        temp = al_create_bitmap(iw, ih);
        al_set_target_bitmap(temp);
        al_clear_to_color(al_map_rgba_f(1, 0, 0, 1));
        start_timer(1);
        al_draw_bitmap_region(screen, x, y, iw, ih, 0, 0, 0);

        al_set_target_bitmap(screen);
        al_draw_bitmap(temp, x + 8 + iw, y, 0);
        stop_timer(1);
        set_xy(x, y + ih);

        al_destroy_bitmap(temp);

        /* Test 3. */
        print("Screen -> Memory -> Screen (%.1f fps)", get_fps(2));
        get_xy(ref x, ref y);
        //al_draw_bitmap(ex.pattern, x, y, 0);

        al_set_new_bitmap_flags(ALLEGRO_MEMORY_BITMAP);
        temp = al_create_bitmap(iw, ih);
        al_set_target_bitmap(temp);
        al_clear_to_color(al_map_rgba_f(1, 0, 0, 1));
        start_timer(2);
        al_draw_bitmap_region(screen, x, y, iw, ih, 0, 0, 0);

        al_set_target_bitmap(screen);
        al_draw_bitmap(temp, x + 8 + iw, y, 0);
        stop_timer(2);
        set_xy(x, y + ih);

        al_destroy_bitmap(temp);
        al_set_new_bitmap_flags(ALLEGRO_VIDEO_BITMAP);

        /* Test 4. */
        print("Screen -> Locked -> Screen (%.1f fps)", get_fps(3));
        get_xy(ref x, ref y);
        //al_draw_bitmap(ex.pattern, x, y, 0);

        start_timer(3);
        @lock = al_lock_bitmap_region(screen, (int)x, (int)y, iw, ih,
           ALLEGRO_PIXEL_FORMAT_ANY, ALLEGRO_LOCK_READONLY);
        //format = @lock.format;
        //size = @lock->pixel_size;
        //data = Marshal.AllocHGlobal(size * iw * ih);
        //for (i = 0; i < ih; i++)
        //    memcpy((char*)data + i * size * iw,
        //       (char*)@lock->data + i * @lock->pitch, size * iw);
        //al_unlock_bitmap(screen);

        //@lock = al_lock_bitmap_region(screen, (int)(x + 8 + iw), (int)y, iw, ih, format,
        //   ALLEGRO_LOCK_WRITEONLY);
        //for (i = 0; i < ih; i++)
        //memcpy((char*)@lock->data + i * @lock->pitch,
        //   (char*)data + i * size * iw, size * iw);
        al_unlock_bitmap(screen);
        //free(data);
        stop_timer(3);
        set_xy(x, y + ih);

    }

    static void tick()
    {
        draw();
        al_flip_display();
    }

    static void run()
    {
        ALLEGRO_EVENT @event = new ALLEGRO_EVENT();
        bool need_draw = true;

        while (true)
        {
            if (need_draw && al_is_event_queue_empty(ex.queue))
            {
                tick();
                need_draw = false;
            }

            al_wait_for_event(ex.queue, ref @event);

            switch (@event.type)
            {
                case ALLEGRO_EVENT_DISPLAY_CLOSE:
                    return;

                case ALLEGRO_EVENT_KEY_DOWN:
                    if (@event.keyboard.keycode == ALLEGRO_KEY_ESCAPE)
                        return;
                    break;

                case ALLEGRO_EVENT_TIMER:
                    need_draw = true;
                    break;
            }
        }
    }

    static void init()
    {
        ex.FPS = 60;

        ex.font = al_load_font("data/fixed_font.tga", 0, 0);
        if (ex.font == IntPtr.Zero)
        {
            Console.WriteLine("data/fixed_font.tga not found\n");
            Environment.Exit(1);
        }
        ex.background = al_color_name("beige");
        ex.text = al_color_name("black");
        ex.white = al_color_name("white");
        ex.pattern = example_bitmap(100, 100);
    }

    static int Main()
    {
        ALLEGRO_DISPLAY display;
        ALLEGRO_TIMER timer;

        if (!al_init())
        {
            abort_example("Could not init Allegro.\n");
            return 1;
        }

        al_install_keyboard();
        al_install_mouse();
        al_init_image_addon();
        al_init_font_addon();

        display = al_create_display(640, 480);
        if (display == IntPtr.Zero)
        {
            abort_example("Error creating display\n");
            return 1;
        }

        init();

        timer = al_create_timer(1.0 / ex.FPS);

        ex.queue = al_create_event_queue();
        al_register_event_source(ex.queue, al_get_keyboard_event_source());
        al_register_event_source(ex.queue, al_get_mouse_event_source());
        al_register_event_source(ex.queue, al_get_display_event_source(display));
        al_register_event_source(ex.queue, al_get_timer_event_source(timer));

        al_start_timer(timer);
        run();

        al_destroy_event_queue(ex.queue);

        return 0;
    }
}