using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using VncSharp;

namespace sharprd
{
    public class VNCTabPage : RDTabPage
    {
        private RemoteDesktop rdp = null;

        private string GetPassword()
        {
            return Encryption.Decrypt(connection.Password);
        }

        public override bool Connected
        {
            get
            {
                return rdp.IsConnected;
            }
        }

        protected override void OnCreateControl()
        {
            rdp = new RemoteDesktop();
            rdp.ConnectComplete += new ConnectCompleteHandler(OnConnected);
            rdp.ConnectionLost += new EventHandler(OnDisconnected);
            this.Controls.Add(rdp);
            rdp.Dock = DockStyle.Fill;
            base.OnCreateControl();
        }

        private void OnConnecting(object sender, EventArgs e)
        {
            connecting = true;
            Notify(this, new NotifyEventArgs(NotifyEventArgs.Actions.Connecting));
        }

        private void OnConnected(object sender, EventArgs e)
        {
            connecting = false;
            Notify(this, new NotifyEventArgs(NotifyEventArgs.Actions.Connected));
        }

        private void OnDisconnected(object sender, EventArgs e)
        {
            connecting = false;
            Notify(this, new NotifyEventArgs(NotifyEventArgs.Actions.Disconnected));

            if (this.Parent != null)
            {
                ((TabControl)this.Parent).TabPages.Remove(this);
            }
        }

        public override void Disconnect()
        {
            try
            {
                if (Connected)
                {
                    rdp.Disconnect();
                }
            }
            catch (Exception)
            {
            }
        }

        public VNCTabPage(RDConnection connection)
            : base(connection)
        {
        }

        public override void Connect()
        {
            OnConnecting(this, new EventArgs());

            if (!string.IsNullOrEmpty(connection.Password))
            {
                rdp.GetPassword = new AuthenticateDelegate(GetPassword);
            }

            try
            {
                rdp.Connect(
                    connection.Computer,
                    false,
                    connection.DisplayMode == RDConnection.DisplayModes.Tabbed);

                if (this.Parent != null)
                {
                    ((TabControl)this.Parent).SelectTab(this);
                }
            }
            catch (VncProtocolException ex)
            {
                MessageBox.Show(this, ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                OnDisconnected(this, new EventArgs());
            }
        }

        public override void Reconnect()
        {
            if (Connected)
            {
                rdp.Disconnect();

                OnConnecting(this, new EventArgs());

                rdp.Connect(
                    connection.Computer,
                    false,
                    connection.DisplayMode == RDConnection.DisplayModes.Tabbed);
            }
        }
    }
}
