﻿using System;
using System.Collections;
using System.IO;
using System.Text;
using System.Windows.Forms;

using allegro;

namespace Mulator
{
    public class Program : Allegro
    {
        private const string VERSION = "0.0.1";

        private static Cpu cpu = new Cpu();

        [STAThread]
        public static void Main(string[] args)
        {
            Console.WriteLine(string.Format("Mulator v{0}", VERSION));

            OpenFileDialog dialog = new OpenFileDialog();

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                Nes nes = new Nes();

                Cartridge cartridge = new Cartridge();
                cartridge.Load(dialog.FileName);

                nes.Cartridge = cartridge;
                nes.RunCart();
            }
        }

        static void SubMain()
        {
            

            #region Allegro Initialization

            allegro_init();
            set_color_depth(desktop_color_depth());
            set_window_title("Mulator v0.0.1");
            set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 240, 0, 0);
            install_keyboard();
            BITMAP buffer = create_bitmap(320, 240);

            #endregion

            FileStream file = new FileStream("../../roms/supermario1.nes", FileMode.Open);
            byte[] nes = new byte[3];
            file.Read(nes, 0, 3);
            Console.WriteLine(Encoding.ASCII.GetString(nes));
            file.Seek(4, SeekOrigin.Begin);
            int PRG_ROM = file.ReadByte();
            int CHR_ROM = file.ReadByte();
            Console.WriteLine(string.Format("{0} of PRG Rom", PRG_ROM));
            Console.WriteLine(string.Format("{0} of CHR Ram", CHR_ROM));
            int Cart_Size = (CHR_ROM << 4) + CHR_ROM * 8;
            int MMC_high_base = (PRG_ROM - 1) * 16384;
            Console.WriteLine(string.Format("Size of the Cartridge : {0} Kb", Cart_Size));

            byte control = (byte)file.ReadByte();
            Console.WriteLine("Mapper: " + (control >> 4));

            switch (control >> 4)
            {
                case 0:
                    Console.WriteLine("No mapper");
                    break;
                default:
                    Console.WriteLine(string.Format("Unknown mapper: {0}", control >> 4));
                    break;
            }

            BitArray controlBits = new BitArray(new byte[] { control });
            bool fourScreenMirroring = controlBits[3];
            Console.WriteLine("Four screen mirroring: " + fourScreenMirroring);
            bool trainer = controlBits[2];
            Console.WriteLine("Trainer: " + trainer);
            bool sramEnabled = controlBits[1];
            Console.WriteLine("SRAM enabled: " + sramEnabled);
            bool mirroring = controlBits[0];
            Console.WriteLine((mirroring == false ? "Horizontal" : "Vertical") + " mirroring");

            Console.WriteLine("Allocating memory...");

            int sizePRG = (PRG_ROM + 1) * 16 * 1024;
            int sizeCHR = (CHR_ROM + 1) * 8 * 1024;

            Memory.Initialize(sizePRG, sizeCHR);

            Console.WriteLine("Loading rom...");
            file.Seek(16, SeekOrigin.Begin);
            file.Read(Memory.ROM, 0, Memory.ROM.Length);

            file.Read(Memory.VRAM, 0, Memory.VRAM.Length);
            Console.WriteLine("Ok");

            file.Close();

            cpu.PC = Memory.Read16(0xFFFC);

            while (!key[KEY_ESC])
            {
                byte opcode = Memory.Read8(cpu.PC);

                cpu.OPCODE = opcode;
                cpu.Execute();



                blit(buffer, screen, 0, 0, 0, 0, 640, 480);
            }
        }
    }
}
