﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mulator
{
    public class Cpu
    {
        public byte OPCODE { get; set; }

        public byte A { get; set; }

        public ushort PC { get; set; }

        public byte InterruptFlag { get; set; }
        public byte DecimalFlag { get; set; }

        public uint Tick { get; set; }

        public void Execute()
        {
            switch (OPCODE)
            {
                case (0X78): SEI(); break; // 120
                case (0xa9): LDA(); break; // 169
                case (0xd8): CLD(); break;  // 216
                default:
                    throw new Exception(string.Format("Unhandled OPCODE: {0:X}", OPCODE));
                    break;
            }
        }

        // SEI - Set interrupt disable
        public void SEI()
        {
            InterruptFlag = 1;
            Tick += 2;
            PC++;
        }

        // LDA - Load accumulator with memory
        public void LDA()
        {
            switch (OPCODE)
            {
                case 0xa9:
                    A = Memory.Read8(PC);
                    Tick += 2;
                    PC += 2;
                    break;
                default:
                    Console.WriteLine(string.Format("Unhandled LDA: {0:X}", OPCODE));
                    break;
            }
        }

        // CLD - Clear decimal mode
        public void CLD()
        {
            DecimalFlag = 0;
            Tick += 2;
            PC++;
        }
    }
}
