using System;
using System.Runtime.InteropServices;
using System.Threading;

using allegro;

public class Video : Allegro
{
    private const int BPP = 16;
    private const int WIDTH = 256;
    private const int HEIGHT = 224;

    BITMAP buffer;

    DateTime dtbefore, dtafter;
    int fps;
    int framecount;
    Nes nes;

    bool willSleep;
    int sleepTime;

    public void BlitScreen()
    {
        for (int j = 0; j < HEIGHT; j++)
        {
            for (int i = 0; i < WIDTH; i++)
            {
                putpixel(buffer, i, j, nes.myPPU.offscreenBuffer[j * WIDTH + i]);
            }
        }

        blit(buffer, screen, 0, 0, 0, 0, WIDTH, HEIGHT);

        framecount++;
        if ((framecount % 100) == 0)
        {
            dtafter = DateTime.Now;
            fps = (int)(((dtafter - dtbefore).Ticks) / 100000);

            if (fps < 100)
            {
                willSleep = true;
                sleepTime++;
            }
            dtbefore = DateTime.Now;
        }

        if (willSleep)
        {
            Thread.Sleep(sleepTime);
        }
    }

    public Video(Nes nes)
    {
        this.nes = nes;
    }

    public void StartVideo()
    {
        allegro_init();

        set_color_depth(BPP);
        set_window_title("mulator v0.0.1");
        set_gfx_mode(GFX_AUTODETECT_WINDOWED, WIDTH, HEIGHT, 0, 0);

        install_keyboard();

        buffer = create_bitmap(WIDTH, HEIGHT);

        dtbefore = DateTime.Now;
        framecount = 0;

        willSleep = false;
        sleepTime = 0;
    }
}
