﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mulator
{
    public class Memory
    {
        public static byte[] RAM;
        public static byte[] ROM;
        public static byte[] VRAM;
        public static byte[] VROM;
        public static byte[] SRAM;

        public static void Initialize(int sizePRG, int sizeCHR)
        {
            RAM = new byte[0x10000];

            ROM = new byte[sizePRG];

            VRAM = new byte[0x4000];

            VROM = new byte[sizeCHR];

            // Save RAM
            SRAM = new byte[0x0100];
        }

        public static byte Read8(ushort address)
        {
            byte returnvalue = 0;

            if (address < 0x2000)
            {
                returnvalue = RAM[address];
            }
            else if (address < 0x6000)
            {
            }
            else if (address < 0x8000)
            {
                returnvalue = SRAM[address - 0x6000];
            }
            else
            {
                returnvalue = ROM[address - 0x8000];
            }
            return returnvalue;
        }

        public static ushort Read16(ushort address)
        {
            byte data_1 = 0;
            byte data_2 = 0;

            if (address < 0x2000)
            {
                data_1 = RAM[address];
                data_2 = RAM[address + 1];
            }
            else if (address < 0x8000)
            {
                data_1 = SRAM[address - 0x6000];
                data_2 = SRAM[address - 0x6000 + 1];
            }
            else
            {
                data_1 = ROM[address - 0x8000];
                data_2 = ROM[address - 0x8000 + 1];
            }

            ushort data = (ushort)((data_2 << 8) + data_1);

            return data;
        }
    }
}
