﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace sharprd
{
    public partial class TextInputDialog : Form
    {
        public string Value
        {
            get
            {
                return txtText.Text;
            }
            set
            {
                txtText.Text = value;
            }
        }

        public TextInputDialog()
        {
            InitializeComponent();

            AcceptButton = btnOk;
            CancelButton = btnCancel;
        }

        public TextInputDialog(string title, string message)
            : this()
        {
            Text = title;
            lblMessage.Text = message;
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.Cancel;
            Close();
        }
    }
}
