﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace sharprd
{
    [Serializable]
    public class Node
    {
        [XmlAttribute]
        public string Name { get; set; }
        [XmlAttribute]
        public bool Folder { get; set; }
        [XmlAttribute]
        public bool Collapsed { get; set; }
        [XmlArray("Nodes"), XmlArrayItem(typeof(Node))]
        public Node[] Nodes { get; set; }
        public RDConnection Connection { get; set; }

        public Node()
        {
        }

        public Node(string name, bool folder)
        {
            this.Name = name;
            this.Folder = folder;
        }
    }
}
