﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace sharprd
{
    public abstract class RDTabPage : TabPage
    {
        protected List<IObserver> observers;
        protected RDConnection connection;
        protected bool connecting;

        public abstract bool Connected
        {
            get;
        }

        public bool Connecting
        {
            get { return connecting; }
            set { connecting = value; }
        }

        public RDTabPage(RDConnection connection)
        {
            observers = new List<IObserver>();
            Attach(connection);
            this.connection = connection;
            Text = connection.Name;
        }

        public void Attach(IObserver observer)
        {
            observers.Add(observer);
        }

        public void Detach(IObserver observer)
        {
            observers.Remove(observer);
        }

        public void Notify(object sender, NotifyEventArgs e)
        {
            foreach (IObserver observer in observers)
            {
                observer.Update();
            }
        }

        public abstract void Connect();

        public abstract void Disconnect();

        public abstract void Reconnect();
    }
}
