﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;
using System.IO;

namespace sharprd
{
    public class Encryption
    {
        private const string RGB_KEY = "jyghqqyndbvmjeiprebatpyjqwpadlqw";
        private const string RGB_IV = "nbjdtuusrijfgcqs";

        public static string Encrypt(string text)
        {
            byte[] clearText = Encoding.UTF8.GetBytes(text);

            SymmetricAlgorithm symmetricAlgorithm = SymmetricAlgorithm.Create();

            byte[] rgbKey = Encoding.ASCII.GetBytes(RGB_KEY.ToUpper());
            byte[] rgbIV = Encoding.ASCII.GetBytes(RGB_IV.ToUpper());

            ICryptoTransform transform = symmetricAlgorithm.CreateEncryptor(rgbKey, rgbIV);

            MemoryStream memoryStream = new MemoryStream();
            CryptoStream cryptoStream = new CryptoStream(memoryStream, transform, CryptoStreamMode.Write);

            cryptoStream.Write(clearText, 0, clearText.Length);
            cryptoStream.Close();

            return Convert.ToBase64String(memoryStream.ToArray());
        }

        public static string Decrypt(string text)
        {
            try
            {
                byte[] encryptedText = Convert.FromBase64String(text);

                SymmetricAlgorithm symmetricAlgorithm = SymmetricAlgorithm.Create();

                byte[] rgbKey = Encoding.ASCII.GetBytes(RGB_KEY.ToUpper());
                byte[] rgbIV = Encoding.ASCII.GetBytes(RGB_IV.ToUpper());

                ICryptoTransform transform = symmetricAlgorithm.CreateDecryptor(rgbKey, rgbIV);

                MemoryStream memoryStream = new MemoryStream();
                CryptoStream cryptoStream = new CryptoStream(memoryStream, transform, CryptoStreamMode.Write);

                cryptoStream.Write(encryptedText, 0, encryptedText.Length);
                cryptoStream.Close();

                return Encoding.UTF8.GetString(memoryStream.ToArray());
            }
            catch
            {
                return string.Empty;
            }
        }
    }
}
