﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using sharphook;

namespace TestSharpHook
{
    public partial class MainWindow : Form
    {
        private SharpHook hook = null;

        int mouseX;
        int mouseY;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (hook != null) hook.Dispose();
        }

        private void clearToolStripButton_Click(object sender, EventArgs e)
        {
            textBox.Clear();
        }

        private void exitToolStripButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void RefreshLabel()
        {
            toolStripStatusLabel1.Text = string.Format(
                "Mouse X: {0} Mouse Y: {1}",
                mouseX, mouseY);
        }

        private void AddText(string text)
        {
            this.textBox.Text += text + Environment.NewLine;
        }

        private void textBox_TextChanged(object sender, EventArgs e)
        {
            textBox.SelectionStart = textBox.Text.Length;
            textBox.ScrollToCaret();
        }

        void hook_KeyDown(object sender, KeyEventArgs e)
        {
            AddText(string.Format("Hook KeyDown: {0} [Modifiers: {1}]", e.KeyCode, e.Modifiers));
        }

        void hook_KeyPress(object sender, KeyPressEventArgs e)
        {
            AddText(string.Format("Hook KeyPress: {0}", e.KeyChar));
        }

        void hook_KeyUp(object sender, KeyEventArgs e)
        {
            AddText(string.Format("Hook KeyUp: {0} [Modifiers: {1}]", e.KeyCode, e.Modifiers));
        }

        void hook_MouseDown(object sender, MouseEventArgs e)
        {
            AddText("MouseDown: " + e.Button.ToString());
        }

        void hook_MouseUp(object sender, MouseEventArgs e)
        {
            AddText("MouseUp: " + e.Button.ToString());
        }

        void hook_Click(object sender, MouseEventArgs e)
        {
            AddText("Click: " + e.Button.ToString());
        }

        void hook_DoubleClick(object sender, MouseEventArgs e)
        {
            AddText("DoubleClick: " + e.Button.ToString());
        }

        void hook_MouseWheel(object sender, MouseEventArgs e)
        {
            AddText("MouseWheel: " + e.Delta);
        }

        void hook_MouseMove(object sender, MouseEventArgs e)
        {
            mouseX = e.X;
            mouseY = e.Y;
            RefreshLabel();
        }

        private void startToolStripButton_Click(object sender, EventArgs e)
        {
            if (startToolStripButton.Text == "Start")
            {
                hook = new SharpHook();
                hook.KeyDown += new KeyEventHandler(hook_KeyDown);
                hook.KeyPress += new KeyPressEventHandler(hook_KeyPress);
                hook.KeyUp += new KeyEventHandler(hook_KeyUp);

                hook.MouseDown += new MouseEventHandler(hook_MouseDown);
                hook.MouseUp += new MouseEventHandler(hook_MouseUp);
                hook.Click += new MouseEventHandler(hook_Click);
                hook.DoubleClick += new MouseEventHandler(hook_DoubleClick);
                hook.MouseWheel += new MouseEventHandler(hook_MouseWheel);
                hook.MouseMove += new MouseEventHandler(hook_MouseMove);

                startToolStripButton.Text = "Stop";
            }
            else
            {
                if (hook != null) hook.Dispose();

                startToolStripButton.Text = "Start";
            }
        }

        private void textBox_KeyDown(object sender, KeyEventArgs e)
        {
            AddText(string.Format("KeyDown: {0} [Modifiers: {1}]", e.KeyCode, e.Modifiers));
        }

        private void textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            AddText(string.Format("KeyPress: {0}", e.KeyChar));
        }

        private void textBox_KeyUp(object sender, KeyEventArgs e)
        {
            AddText(string.Format("KeyUp: {0} [Modifiers: {1}]", e.KeyCode, e.Modifiers));
        }        
    }
}
