﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using sharphook;

namespace TestSharpHook
{
    public partial class MainWindow : Form
    {
        private SharpHook hook = null;

        int mouseX;
        int mouseY;

        public MainWindow()
        {
            InitializeComponent();

            //hook = new SharpHook(SharpHook.HookType.Keyboard);
            hook = new SharpHook();
            hook.KeyDown += new KeyEventHandler(hook_KeyDown);
            hook.KeyPress += new KeyPressEventHandler(hook_KeyPress);
            hook.KeyUp += new KeyEventHandler(hook_KeyUp);

            hook.MouseDown += new MouseEventHandler(hook_MouseDown);
            hook.MouseUp += new MouseEventHandler(hook_MouseUp);
            hook.Click += new MouseEventHandler(hook_Click);
            hook.DoubleClick += new MouseEventHandler(hook_DoubleClick);
            hook.MouseWheel += new MouseEventHandler(hook_MouseWheel);
            hook.MouseMove += new MouseEventHandler(hook_MouseMove);
        }

        private void MainWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (hook != null) hook.Dispose();
        }

        private void clearToolStripButton_Click(object sender, EventArgs e)
        {
            textBox.Clear();
        }

        private void exitToolStripButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void RefreshLabel()
        {
            toolStripStatusLabel1.Text = string.Format(
                "Mouse X: {0} Mouse Y: {1}",
                mouseX, mouseY);
        }

        private void AddText(string text)
        {
            this.textBox.Text += text + Environment.NewLine;
        }

        private void textBox_TextChanged(object sender, EventArgs e)
        {
            textBox.SelectionStart = textBox.Text.Length;
            textBox.ScrollToCaret();
        }

        void hook_KeyDown(object sender, KeyEventArgs e)
        {
            AddText(string.Format("KeyDown: {0} Modifiers: {1} Alt: {2} Control: {3} Shift: {4}", e.KeyCode, e.Modifiers, e.Alt, e.Control, e.Shift));
        }

        void hook_KeyPress(object sender, KeyPressEventArgs e)
        {
            AddText("KeyPress: " + e.KeyChar.ToString());
        }

        void hook_KeyUp(object sender, KeyEventArgs e)
        {
            AddText("KeyUp: " + e.KeyCode.ToString());
        }

        void hook_MouseDown(object sender, MouseEventArgs e)
        {
            AddText("MouseDown: " + e.Button.ToString());
        }

        void hook_MouseUp(object sender, MouseEventArgs e)
        {
            AddText("MouseUp: " + e.Button.ToString());
        }

        void hook_Click(object sender, MouseEventArgs e)
        {
            AddText("Click: " + e.Button.ToString());
        }

        void hook_DoubleClick(object sender, MouseEventArgs e)
        {
            AddText("DoubleClick: " + e.Button.ToString());
        }

        void hook_MouseWheel(object sender, MouseEventArgs e)
        {
            AddText("MouseWheel: " + e.Delta);
        }

        void hook_MouseMove(object sender, MouseEventArgs e)
        {
            mouseX = e.X;
            mouseY = e.Y;
            RefreshLabel();
        }
    }
}
