﻿using System;
using System.Collections.Generic;
using System.Text;

namespace sharpmines
{
    public class Highscore
    {
        private static List<Highscore> highscores = new List<Highscore>();

        public static List<Highscore> Highscores
        {
            get { return Highscore.highscores; }
            set { Highscore.highscores = value; }
        }

        public static bool IsHighscore(Highscore highscore)
        {
            if (highscores.Count < 4)
            {
                return true;
            }
            else
            {
                for (int i = 0; i < highscores.Count; i++)
                {
                    if (highscore.time < highscores[i].time)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public static int HighscorePosition(Highscore highscore)
        {
            for (int i = 0; i < highscores.Count; i++)
            {
                if (highscore.time < highscores[i].time)
                {
                    return i;
                }
            }
            return -1;
        }

        public static void Add(Highscore highscore)
        {
            highscores.Add(highscore);

            highscores.Sort(delegate(Highscore s1, Highscore s2)
            {
                return s1.Time.CompareTo(s2.Time);
            });

            if (highscores.Count > 4)
            {
                highscores.RemoveRange(4, highscores.Count - 4);
            }
        }

        private string name;
        private int time;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public int Time
        {
            get { return time; }
            set { time = value; }
        }

        public Highscore(string name, int time)
        {
            this.name = name;
            this.time = time;
        }

        public Highscore()
        {
        }
    }
}
