﻿using System;
using System.Collections.Generic;
using System.Text;

namespace sharpmines
{
    public class Difficulty
    {
        public enum Difficulties
        {
            Beginner,
            Intermediate,
            Advanced
        }

        public Difficulties DifficultyLevel { get; set; }
        public int Width { get; set; }
        public int Height { get; set; }
        public int Mines { get; set; }

        public Difficulty(int width, int height, int mines)
        {
            this.Width = width;
            this.Height = height;
            this.Mines = mines;
        }

        public Difficulty(Difficulties difficultyLevel)
        {
            this.DifficultyLevel = difficultyLevel;

            switch (difficultyLevel)
            {
                case Difficulties.Beginner:
                    this.Width = 9;
                    this.Height = 9;
                    this.Mines = 10;
                    break;
                case Difficulties.Intermediate:
                    this.Width = 16;
                    this.Height = 16;
                    this.Mines = 40;
                    break;
                case Difficulties.Advanced:
                    this.Width = 30;
                    this.Height = 16;
                    this.Mines = 99;
                    break;
            }
        }
    }
}
