using System;

using allegro;

public class Timer : Allegro, IDisposable
{
    private const int MAX_TIME = 1000000000;
    volatile static int time = 0;

    static void timer()
    {
        time += 10;
        if (time > MAX_TIME) time = 0;
    }

    static TimerHandler timerHandler = new TimerHandler(timer);

    public int Time
    {
        get
        {
            return time;
        }
    }

    private static Timer instance = null;

    public static Timer Instance
    {
        get
        {
            if (instance == null) instance = new Timer();
            return instance;
        }
    }

    private Timer()
    {
        LOCK_VARIABLE(time);
        LOCK_FUNCTION(timerHandler);
        install_int(timerHandler, 10);
    }

    public int elapsedTime(int previousTime)
    {
        if (previousTime > Time) return Time + (MAX_TIME - previousTime);
        return Time - previousTime;
    }

    #region IDisposable Members

    public void Dispose()
    {
        remove_int(timerHandler);
    }

    #endregion
}