﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xrm.Sdk;

namespace XrmTools
{
    class Program
    {
        private static Dictionary<Guid, string> references = new Dictionary<Guid, string>();

        public static bool CheckReference(Guid referenceId, Entity entity)
        {
            // Stiamo controllando lo stesso oggetto
            if (entity.Id == referenceId) return false;

            foreach (var value in entity.Attributes)
            {
                switch (value.Value.GetType().Name)
                {
                    case "Guid":
                        if ((Guid)value.Value == referenceId)
                        {
                            return true;
                        }
                        break;
                    case "EntityReference":
                        if (((EntityReference)value.Value).Id == referenceId)
                        {
                            return true;
                        }
                        break;
                    case "EntityCollection":
                        foreach (Entity innerEntity in ((EntityCollection)value.Value).Entities)
                        {
                            if (CheckReference(referenceId, innerEntity))
                            {
                                return true;
                            }
                        }
                        break;
                }
            }

            return false;
        }

        public static bool CheckReference(Guid referenceId, EntityCollection collection)
        {
            bool ret = false;

            foreach (Entity entity in collection.Entities)
            {
                if (CheckReference(referenceId, entity))
                {
                    references[entity.Id] = entity.LogicalName;
                    ret = true;
                    return true;
                }
            }

            return ret;
        }

        public static void CheckReference(string logicalName, Guid guid)
        {
            try
            {
                Entity referenceEntity = EntityUtility.ReadEntity(logicalName, guid);

                string[] entities = EntityUtility.ReadEntityNames();

                foreach (string entity in entities)
                {
                    Console.Write(entity + " ");
                    EntityCollection collection = EntityUtility.ReadEntities(entity);
                    Console.WriteLine(CheckReference(referenceEntity.Id, collection) ? "*KO*" : "OK");
                }
            }
            catch
            {
                Console.WriteLine("Entity not found!");
                return;
            }

            Console.WriteLine(Environment.NewLine + "Check complete...");

            if (references.Count > 0)
            {
                Console.WriteLine(Environment.NewLine + "References:");
                foreach (var reference in references)
                {
                    Console.WriteLine(string.Format("\"{0}\" -> {{{1}}}. Do you want to delete it? (Y/N)", reference.Value, reference.Key));
                    if (Console.ReadKey().KeyChar == 'Y')
                    {
                        XrmUtils.Delete(reference.Value, reference.Key);
                    }
                }
            }
        }

        static void Main(string[] args)
        {
            Console.Write("Insert entity logical name:");
            string logicalName = Console.ReadLine();

            Console.Write(string.Format("Insert entity Id {{{0}}}:", Guid.Empty.ToString()));
            string guid = Console.ReadLine();

            if (!string.IsNullOrEmpty(logicalName) && !string.IsNullOrEmpty(guid))
            {
                CheckReference(logicalName, new Guid(guid));
            }

            Console.WriteLine(Environment.NewLine + "Process complete...");
            Console.ReadKey();
        }
    }
}
