﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Configuration;
using System.ServiceModel.Description;

using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Metadata;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Client;
using Microsoft.Xrm.Client.Services;

namespace XrmTools
{
    public class XrmUtils
    {
        public static CrmConnection GetCrmConnection()
        {
            CrmConnection crmConn = new CrmConnection("CRM");
            crmConn.ServiceUri = new Uri(ConfigurationManager.AppSettings["msa.CRMServerUrl"]);
            crmConn.ClientCredentials.UserName.UserName = ConfigurationManager.AppSettings["msa.CRMWebServicesUser"];
            crmConn.ClientCredentials.UserName.Password = ConfigurationManager.AppSettings["msa.CRMWebServicesPassword"];
            return crmConn;
        }

        public static Guid Create(Entity entity) {
            OrganizationService org = new OrganizationService(GetCrmConnection());
            return org.Create(entity);
        }
        public static void Update(Entity entity)
        {
            OrganizationService org = new OrganizationService(GetCrmConnection());
            org.Update(entity);
        }
        public static void Delete(string entityName, Guid entityId)
        {
            OrganizationService org = new OrganizationService(GetCrmConnection());
            org.Delete(entityName, entityId);
        }
    }
}
