﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;

using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Metadata;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Client;
using Microsoft.Xrm.Client.Services;

namespace XrmTools
{
    public class EntityUtility
    {
        public static EntityMetadata GetEntityMetadata(string entityLogicalName)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            return org.RetrieveEntity(entityLogicalName, EntityFilters.Attributes, false);
        }

        public static List<AttributeMetadata> GetAllAttributeMetadataByEntity(string entityLogicalName)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            EntityMetadata entityMetadata = GetEntityMetadata(entityLogicalName);

            List<AttributeMetadata> results = new List<AttributeMetadata>();
            foreach (AttributeMetadata attribute in entityMetadata.Attributes)
            {
                results.Add(attribute);
            }

            return results;
        }

        public static Entity ReadEntity(string entityName, Guid entityId)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            EntityMetadata metadata = EntityUtility.GetEntityMetadata(entityName);
            List<string> columns = new List<string>();
            foreach (AttributeMetadata attr in metadata.Attributes)
            {
                if ((bool)attr.IsValidForRead && (bool)attr.IsValidForUpdate && (bool)attr.IsValidForCreate)
                    columns.Add(attr.LogicalName);
            }
            Microsoft.Xrm.Sdk.Query.ColumnSet columnSet = new Microsoft.Xrm.Sdk.Query.ColumnSet(columns.ToArray());

            return org.Retrieve(entityName, entityId, columnSet);
        }

        public static Entity ReadEntity(string entityName, Guid entityId, params string[] attributes)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            Microsoft.Xrm.Sdk.Query.ColumnSet columnSet = new Microsoft.Xrm.Sdk.Query.ColumnSet(attributes);

            RetrieveAllEntitiesRequest req = new RetrieveAllEntitiesRequest();
            req.EntityFilters = EntityFilters.Entity;
            req.RequestName = "RetrieveAllEntities";
            EntityMetadata[] a = (EntityMetadata[])org.Execute(req).Results.Values.ElementAt(0);
            List<String> strings = new List<string>();
            foreach (EntityMetadata meta in a)
            {
                strings.Add(meta.LogicalName);
            }
            strings.Sort();
            return org.Retrieve(entityName, entityId, columnSet);
        }

        public static Entity ReadEntity(string entityName, string name, params string[] attributes)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            EntityCollection entities = ReadEntities(entityName, attributes);
            Entity entity = null;
            for (int i = 0; i < entities.Entities.Count; i++)
            {
                try
                {
                    if (entities.Entities[i].Attributes["name"].Equals(name))
                        entity = entities.Entities[i];
                }
                catch (Exception e) {
                    Console.WriteLine(e.Message);
                }
            }
            return entity;
        }

        public static Entity ReadEntity(string entityName, string name)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            EntityMetadata metadata = EntityUtility.GetEntityMetadata(entityName);
            List<string> columns = new List<string>();
            foreach (AttributeMetadata attr in metadata.Attributes)
            {
                if ((bool)attr.IsValidForRead && (bool)attr.IsValidForUpdate && (bool)attr.IsValidForCreate)
                    columns.Add(attr.LogicalName);
            }
            EntityCollection entities = ReadEntities(entityName, columns.ToArray());
            Entity entity = null;
            for (int i = 0; i < entities.Entities.Count; i++)
            {
                try
                {
                    if (entities.Entities[i].Attributes["name"].Equals(name))
                        entity = entities.Entities[i];
                }
                catch (Exception e) {
                    Console.WriteLine(e.Message);
                }
            }
            return entity;
        }

        public static EntityCollection ReadEntities(string entityName, params string[] attributes)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            Microsoft.Xrm.Sdk.Query.QueryExpression query = new Microsoft.Xrm.Sdk.Query.QueryExpression(entityName);
            query.ColumnSet.AddColumns(attributes);
            return org.RetrieveMultiple(query);
        }

        public static EntityCollection ReadEntities(string entityName)
        {
            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            EntityMetadata metadata = EntityUtility.GetEntityMetadata(entityName);
            List<string> columns = new List<string>();
            List<string> s = new List<string>();
            foreach (AttributeMetadata attr in metadata.Attributes)
            {
                s.Add(attr.LogicalName);
                if ((bool)attr.IsValidForRead && (bool)attr.IsValidForUpdate && (bool)attr.IsValidForCreate)
                    columns.Add(attr.LogicalName);
            }
            Microsoft.Xrm.Sdk.Query.QueryExpression query = new Microsoft.Xrm.Sdk.Query.QueryExpression(entityName);
            query.ColumnSet.AddColumns(columns.ToArray());

            return org.RetrieveMultiple(query);
        }

        public static string[] ReadEntityNames()
        {
            List<string> entityNames = new List<string>();

            OrganizationService org = new OrganizationService(XrmUtils.GetCrmConnection());
            RetrieveAllEntitiesRequest request = new RetrieveAllEntitiesRequest()
            {
                EntityFilters = EntityFilters.Entity,
                RetrieveAsIfPublished = true
            };

            RetrieveAllEntitiesResponse response = (RetrieveAllEntitiesResponse)org.Execute(request);

            foreach (EntityMetadata metaData in response.EntityMetadata)
            {
                //if (metaData.OwnershipType.HasValue && metaData.OwnershipType.Value != OwnershipTypes.None) // 134 (child attributes issue)
                if (
                    (metaData.IsValidForAdvancedFind.HasValue && metaData.IsValidForAdvancedFind.Value) // 85
                    || (metaData.IsManaged.HasValue && !metaData.IsManaged.Value) // 8
                    || (metaData.IsImportable.HasValue && metaData.IsImportable.Value) // 72
                )
                    entityNames.Add(metaData.LogicalName);
            }

            return entityNames.ToArray();
        }
    }
}