using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Xml.Serialization;
using System.Drawing;

namespace sharprd
{
    [Serializable]
    public class RDConnection : IObserver, IComparable
    {
        public enum Types
        {
            RDP,
            VNC
        }

        public enum ColorDepths
        {
            Color256 = 8,
            HighColor15 = 15,
            HighColor16 = 16,
            TrueColor24 = 24,
            TrueColor32 = 32
        }

        public enum DisplayModes
        {
            Fullscreen = 0,
            Tabbed = 1,
        }

        public enum RemoteAudioConfiguration
        {
            PlayOnThisComputer = 0,
            DoNotPlay,
            PlayOnRemoteComputer
        }

        public enum PerformancePresets
        {
            Modem = 0,
            LowBroadband,
            Satellite,
            HighBroadband,
            WAN,
            LAN
        }

        private Types type;
        private string name;
        private string computer;
        private string domain;
        private string username;
        private string password;
        private DisplayModes displayMode;
        private ColorDepths colorDepth;
        private bool displayConnectionBar;
        private bool console;
        private RemoteAudioConfiguration remoteAudio;
        private bool printers;
        private bool clipboard;
        private bool drives;
        private PerformancePresets performancePreset;
        private bool desktopBackground;
        private bool fontSmoothing;
        private bool desktopComposition;
        private bool windowContents;
        private bool menuAnimation;
        private bool visualStyles;
        private bool persistentBitmapCaching;

        private RDTabPage page;
        private bool connected;
        private bool connecting;

        public Types Type
        {
            get { return type; }
            set { type = value; }
        }

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public string Computer
        {
            get { return computer; }
            set { computer = value; }
        }

        public string Domain
        {
            get { return domain; }
            set { domain = value; }
        }

        public string Username
        {
            get { return username; }
            set { username = value; }
        }

        public string Password
        {
            get { return password; }
            set { password = value; }
        }

        public DisplayModes DisplayMode
        {
            get { return displayMode; }
            set { displayMode = value; }
        }

        public ColorDepths ColorDepth
        {
            get { return colorDepth; }
            set { colorDepth = value; }
        }

        public bool DisplayConnectionBar
        {
            get { return displayConnectionBar; }
            set { displayConnectionBar = value; }
        }

        public bool Console
        {
            get { return console; }
            set { console = value; }
        }

        public RemoteAudioConfiguration RemoteAudio
        {
            get { return remoteAudio; }
            set { remoteAudio = value; }
        }

        public bool Printers
        {
            get { return printers; }
            set { printers = value; }
        }

        public bool Clipboard
        {
            get { return clipboard; }
            set { clipboard = value; }
        }

        public bool Drives
        {
            get { return drives; }
            set { drives = value; }
        }

        public PerformancePresets PerformancePreset
        {
            get { return performancePreset; }
            set { performancePreset = value; }
        }

        public bool DesktopBackground
        {
            get { return desktopBackground; }
            set { desktopBackground = value; }
        }

        public bool FontSmoothing
        {
            get { return fontSmoothing; }
            set { fontSmoothing = value; }
        }

        public bool DesktopComposition
        {
            get { return desktopComposition; }
            set { desktopComposition = value; }
        }

        public bool WindowContents
        {
            get { return windowContents; }
            set { windowContents = value; }
        }

        public bool MenuAnimation
        {
            get { return menuAnimation; }
            set { menuAnimation = value; }
        }

        public bool VisualStyles
        {
            get { return visualStyles; }
            set { visualStyles = value; }
        }

        public bool PersistentBitmapCaching
        {
            get { return persistentBitmapCaching; }
            set { persistentBitmapCaching = value; }
        }

        [XmlIgnore]
        public RDTabPage Page
        {
            get { return page; }
            set { page = value; }
        }

        [XmlIgnore]
        public bool Connected
        {
            get { return connected; }
            set { connected = value; }
        }

        [XmlIgnore]
        public bool Connecting
        {
            get { return connecting; }
            set { connecting = value; }
        }

        [XmlIgnore]
        public int ImageIndex
        {
            get
            {
                return Connected ? 3 : Connecting ? 1 : 0;
            }
        }

        public RDConnection()
        {
            this.type = Types.RDP;
            this.name = string.Empty;
            this.computer = string.Empty;
            this.domain = string.Empty;
            this.username = string.Empty;
            this.password = string.Empty;
            this.displayMode = DisplayModes.Tabbed;
            this.colorDepth = ColorDepths.Color256;
            this.displayConnectionBar = false;
            this.console = false;
            this.remoteAudio = RemoteAudioConfiguration.DoNotPlay;
            this.clipboard = false;
            this.drives = false;
            this.printers = false;
            this.performancePreset = PerformancePresets.Modem;
            this.desktopBackground = false;
            this.fontSmoothing = false;
            this.desktopComposition = false;
            this.windowContents = false;
            this.menuAnimation = false;
            this.visualStyles = false;
            this.persistentBitmapCaching = false;
        }

        public RDConnection(
            string name,
            string computer,
            string domain,
            string username,
            string password,
            ColorDepths colorDepth)
        {
            this.name = name;
            this.computer = computer;
            this.domain = domain;
            this.username = username;
            this.password = password;
            this.colorDepth = colorDepth;
        }

        public override string ToString()
        {
            return Name;
        }

        #region IObserver Members

        public void Update()
        {
            connected = page != null ? page.Connected : false;
            connecting = page != null ? page.Connecting : false;
        }

        #endregion

        #region IComparable Members

        public int CompareTo(object obj)
        {
            return Name.CompareTo(((RDConnection)obj).Name);
        }

        #endregion
    }
}
