﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using allegro;
using alleggl;

public class exmipmaps : AllegGL
{
    struct texture_t
    {
        public BITMAP bitmap;
        public uint id;
    }

    static int Main()
    {
        int flags;
        texture_t texture;
        FONT agl_font;

        allegro_init();
        install_allegro_gl();
        install_keyboard();
        install_timer();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_Z_DEPTH, 24);
        allegro_gl_set(AGL_WINDOWED, TRUE);
        allegro_gl_set(AGL_RENDERMETHOD, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER
                                  | AGL_RENDERMETHOD | AGL_Z_DEPTH | AGL_WINDOWED);

        if (set_gfx_mode(GFX_OPENGL, 800, 600, 0, 0) != 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                            "Allegro GL error : {1}\n",
                            allegro_error, allegro_gl_error));
            return -1;
        }

        /* Create a checkered bitmap */
        {
            int i, j;
            int[] col = new int[2];

            col[0] = makecol(0, 0, 0);
            col[1] = makecol(255, 255, 255);

            int TW = 64;
            int TH = 64;

            texture.bitmap = create_bitmap(TW, TH);

            int PW = 8;
            int PH = 8;

            for (j = 0; j < PH; j++)
            {
                for (i = 0; i < PW; i++)
                {
                    rectfill(texture.bitmap, i * TW / PW, j * TH / PH,
                             (i + 1) * TW / PW, (j + 1) * TH / PH,
                             col[(i ^ j) & 1]);
                }
            }

            //#undef TW
            //#undef TH
            //#undef PW
            //#undef PH
        }

        /* Create a texture from the bitmap and generate mipmaps */
        flags = AGL_TEXTURE_MIPMAP | AGL_TEXTURE_RESCALE;
        texture.id = allegro_gl_make_texture_ex(flags, texture.bitmap, (int)OpenGL.GL_RGBA8);

        /* Get an AGL font by converting Allegro's */
        agl_font = allegro_gl_convert_allegro_font_ex(font,
                                      AGL_FONT_TYPE_TEXTURED, -1.0f, (int)OpenGL.GL_INTENSITY8);

        run(ref texture, agl_font);

        return 0;
    }

    static volatile int the_time = 0;
    const int TIME_SCALE = 500;

    static TimerHandler _the_timer = new TimerHandler(the_timer);
    static void the_timer()
    {
        the_time++;
        if (the_time > TIME_SCALE)
        {
            the_time -= TIME_SCALE;
        }
    }

    static void run(ref texture_t texture, FONT agl_font)
    {

        string[] text = { "Trilinear w/ Aniso",  "Trilinear",
		                          "Bilinear w/ Aniso",   "Bilinear"};
        uint[] min_filter = { OpenGL.GL_LINEAR_MIPMAP_LINEAR, OpenGL.GL_LINEAR };
        float[] max_aniso = { 16, 1 };

        int i, j;

        int has_aniso = AGL_EXTENSION_LIST_GL.allegro_gl_extensions_GL.EXT_texture_filter_anisotropic;

        /* Draw an oblique GL_QUAD in 4 modes:
         *     Bilinear + Aniso  |     Bilinear
         *    -----------------------------------------
         *    Trilinear + Aniso  |    Trilinear
         */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glBindTexture(OpenGL.GL_TEXTURE_2D, texture.id);

        OpenGL.glTexParameteri(OpenGL.GL_TEXTURE_2D, OpenGL.GL_TEXTURE_MAG_FILTER, (int)OpenGL.GL_LINEAR);
        OpenGL.glEnable(OpenGL.GL_SCISSOR_TEST);

        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glFrustum(-1, 1, -1, 1, 1, 10);
        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);

        install_int(the_timer, 20);

        do
        {
            float t = the_time / (float)TIME_SCALE;

            OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT);

            if (has_aniso == 0)
            {
                string _text = "EXT_texture_filter_anisotropic not " +
                                          "supported!";
                int len = text_length(font, _text);

                OpenGL.glViewport(0, 0, SCREEN_W, SCREEN_H);

                allegro_gl_set_projection();
                OpenGL.glTranslatef(-0.375f, -0.375f, 0f);
                OpenGL.glTranslatef(5, 5, 0);

                for (j = 0; j < 2; j++)
                {
                    rectfill(screen, 0, j * SCREEN_H / 2,
                                     len, j * SCREEN_H / 2 + 8,
                                     makecol(0, 0, 0));

                    allegro_gl_printf(agl_font, 0, j * SCREEN_H / 2, 0,
                                      makecol(255, 255, 255),
                                      string.Format("{0}", text));
                }
                OpenGL.glTranslatef(+0.375f, +0.375f, 0f);
                allegro_gl_unset_projection();
            }

            for (j = 0; j < 2; j++)
            {
                //for (i = has_aniso ? 0 : 1; i < 2; i++)
                for (i = has_aniso != 0 ? 0 : 1; i < 2; i++)
                {
                    int len = text_length(font, text[i + j * 2]);

                    OpenGL.glTexParameteri(OpenGL.GL_TEXTURE_2D, OpenGL.GL_TEXTURE_MIN_FILTER,
                                    (int)min_filter[j]);
                    OpenGL.glTexParameteri(OpenGL.GL_TEXTURE_2D, OpenGL.GL_TEXTURE_MAX_ANISOTROPY_EXT,
                                    (int)max_aniso[i]);

                    OpenGL.glViewport(i * SCREEN_W / 2, j * SCREEN_H / 2, SCREEN_W / 2, SCREEN_H / 2);

                    OpenGL.glBegin(OpenGL.GL_TRIANGLES);
                    OpenGL.glTexCoord2f(t, t); OpenGL.glVertex3f(-1, 1, -1);
                    OpenGL.glTexCoord2f(10 + t, t); OpenGL.glVertex3f(0, 0, -10);
                    OpenGL.glTexCoord2f(t, 1 + t); OpenGL.glVertex3f(-1, -1, -1);

                    OpenGL.glTexCoord2f(-t, -t); OpenGL.glVertex3f(-1, 1, -1);
                    OpenGL.glTexCoord2f(10 - t, -t); OpenGL.glVertex3f(0, 0, -10);
                    OpenGL.glTexCoord2f(-t, 1 - t); OpenGL.glVertex3f(1, 1, -1);

                    OpenGL.glTexCoord2f(-t, -t); OpenGL.glVertex3f(1, 1, -1);
                    OpenGL.glTexCoord2f(10 - t, -t); OpenGL.glVertex3f(0, 0, -10);
                    OpenGL.glTexCoord2f(-t, 1 - t); OpenGL.glVertex3f(1, -1, -1);

                    OpenGL.glTexCoord2f(-t, -t); OpenGL.glVertex3f(1, -1, -1);
                    OpenGL.glTexCoord2f(10 - t, -t); OpenGL.glVertex3f(0, 0, -10);
                    OpenGL.glTexCoord2f(-t, 1 - t); OpenGL.glVertex3f(-1, -1, -1);
                    OpenGL.glEnd();

                    allegro_gl_set_projection();
                    OpenGL.glTranslatef(-0.375f, -0.375f, 0f);
                    OpenGL.glTranslatef(5, 5, 0);

                    rectfill(screen, i * SCREEN_W / 2, j * SCREEN_H / 2,
                                     i * SCREEN_W / 2 + len, j * SCREEN_H / 2 + 8,
                                     makecol(0, 0, 0));

                    allegro_gl_printf(agl_font, i * SCREEN_W / 2, j * SCREEN_H / 2, 0,
                                      makecol(255, 255, 255),
                                      string.Format("{0}", text[i + j * 2]));

                    OpenGL.glTranslatef(+0.375f, +0.375f, 0f);
                    allegro_gl_unset_projection();

                }
            }
            allegro_gl_flip();
            rest(2);
        } while (!keypressed());
    }
}