﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using allegro;
using alleggl;
using System.Runtime.InteropServices;

public class dialog : AllegGL
{
    struct _camera
    {
        public double xangle, yangle, zangle;
        public double dist;

        public _camera(double xangle, double yangle, double zangle, double dist)
        {
            this.xangle = xangle;
            this.yangle = yangle;
            this.zangle = zangle;
            this.dist = dist;
        }
    }

    static _camera camera = new _camera(
        0.0, 0.0, 0.0,
        20.0);

    static double angle_speed = 5.0;
    static double dist_speed = 1.0;

    static int frames = 0;
    static volatile int secs;

    static TimerHandler _secs_timer = new TimerHandler(secs_timer);
    static void secs_timer()
    {
        secs++;
    }

    static void set_camera_position()
    {
        /* Note: Normally, you won't build the camera using the Projection
         * matrix. See excamera.c on how to build a real camera.
         * This code is there just to simplify this test program a bit.
         */
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 40.0);
        OpenGL.glTranslatef(0, 0, (float)-camera.dist);
        OpenGL.glRotatef((float)camera.xangle, 1, 0, 0);
        OpenGL.glRotatef((float)camera.yangle, 0, 1, 0);
        OpenGL.glRotatef((float)camera.zangle, 0, 0, 1);
        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
    }

    static void keyboard()
    {
        if (key[KEY_LEFT]) camera.yangle += angle_speed;
        if (key[KEY_RIGHT]) camera.yangle -= angle_speed;

        if (key[KEY_UP]) camera.xangle += angle_speed;
        if (key[KEY_DOWN]) camera.xangle -= angle_speed;

        if (key[KEY_PGUP]) camera.dist -= dist_speed;
        if (key[KEY_PGDN]) camera.dist += dist_speed;

        if (key[KEY_D]) alert("You pressed D", null, null, "OK", null, 0, 0);

        set_camera_position();
        display();
    }

    static void display()
    {
        // Clear the RGB buffer and the depth buffer
        OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);

        // Set the modelview matrix to be the identity matrix
        OpenGL.glLoadIdentity();
        // Translate and rotate the object
        OpenGL.glTranslatef(-2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(-30, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(30, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(30, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(1.0f, 0.0f, 1.0f);

        // Draw the sides of the three-sided pyramid
        OpenGL.glBegin(OpenGL.GL_TRIANGLE_FAN);
        OpenGL.glVertex3d(0, 4, 0);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 1.0f, 1.0f);

        // Draw the base of the pyramid
        OpenGL.glBegin(OpenGL.GL_TRIANGLES);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glEnd();

        OpenGL.glLoadIdentity();
        OpenGL.glTranslatef(2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(45, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(45, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(45, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(0.0f, 1.0f, 0.0f);

        // Draw the sides of the cube
        OpenGL.glBegin(OpenGL.GL_QUAD_STRIP);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glVertex3d(-3, -3, 3);
        OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 0.0f, 1.0f);

        // Draw the top and bottom of the cube
        OpenGL.glBegin(OpenGL.GL_QUADS);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(-3, -3, 3);

        OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glEnd();

        OpenGL.glFlush();

        allegro_gl_flip();

        frames++;
    }

    static int mode = AGL_FULLSCREEN, width, height;

    [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
    public delegate string DialogLister(int index, IntPtr list_size);

    struct resolution_entry
    {
        public int w, h;
        public string s;

        public resolution_entry(int w, int h, string s)
        {
            this.w = w;
            this.h = h;
            this.s = s;
        }
    }

    static resolution_entry[] resolutions = {
        new resolution_entry(  320,  240, " 320x240 "  ),
        new resolution_entry(  640,  480, " 640x480 "  ),
        new resolution_entry(  800,  600, " 800x600 "  ),
        new resolution_entry( 1024,  768, "1024x768 "  ),
        new resolution_entry( 1280, 1024, "1280x1024" ),
        new resolution_entry( 1600, 1200, "1600x1200" )
    };

    static string resolution_lister(int i, IntPtr size)
    {
        if (i < 0)
        {
            //*size = sizeof resolutions / sizeof *resolutions;
            Marshal.WriteInt32(size, resolutions.Length);
            return null;
        }
        return resolutions[i].s;
    }
    static DialogLister d_resolution_lister = new DialogLister(resolution_lister);    

    struct colour_depth_entry
    {
        public int depth;
        public string s;

        public colour_depth_entry(int depth, string s)
        {
            this.depth = depth;
            this.s = s;
        }
    }

    static colour_depth_entry[] colour_depths = {
        new colour_depth_entry(  8, " 8 bpp" ),
        new colour_depth_entry( 15, "15 bpp" ),
        new colour_depth_entry( 16, "16 bpp" ),
        new colour_depth_entry( 24, "24 bpp" ),
        new colour_depth_entry( 32, "32 bpp" )
    };

    static string colour_depth_lister(int i, IntPtr size)
    {
        if (i < 0)
        {
            //*size = sizeof colour_depths / sizeof *colour_depths;
            Marshal.WriteInt32(size, colour_depths.Length);
            return null;
        }
        return colour_depths[i].s;
    }
    static DialogLister d_colour_depth_lister = new DialogLister(colour_depth_lister);

    struct zbuffer_depth_entry {
        public int depth;
        public string s;

                public zbuffer_depth_entry(int depth, string s)
        {
            this.depth = depth;
            this.s = s;
        }
    }
    static zbuffer_depth_entry[] zbuffer_depths = {
        new zbuffer_depth_entry(  8, " 8 bits" ),
        new zbuffer_depth_entry( 16, "16 bits" ),
        new zbuffer_depth_entry( 24, "24 bits" ),
        new zbuffer_depth_entry( 32, "32 bits" )
    };

    static string zbuffer_depth_lister (int i, IntPtr size)
    {
        if (i < 0) {
            //*size = sizeof zbuffer_depths / sizeof *zbuffer_depths;
            Marshal.WriteInt32(size, zbuffer_depths.Length);
            return null;
        }
        return zbuffer_depths[i].s;
    }
    static DialogLister d_zbuffer_depth_lister = new DialogLister(zbuffer_depth_lister);

    static DIALOGS dlg = new DIALOGS(15);

    static int setup()
    {
        const int RESOLUTION_LIST = 4;
        const int COLOUR_LIST = 6;
        const int ZBUFFER_LIST = 8;
        const int WINDOWED_BOX = 9;
        const int DOUBLEBUFFER_BOX = 10;
        const int BUTTON_OK = 11;

        //DIALOG dlg[] = {
        ///*	proc                 x    y    w    h  fg bg  key    flags d1 d2  dp */
        //{	d_shadow_box_proc,   0,   0, 320, 200,  0, 0,   0,         0, 0, 0, NULL, NULL, NULL },
        //{	d_ctext_proc,      160,  10,   0,   0,  0, 0,   0,         0, 0, 0, "____________", NULL, NULL },
        //{	d_ctext_proc,      160,   8,   0,   0,  0, 0,   0,         0, 0, 0, "OpenGL Setup", NULL, NULL },
        //{	d_text_proc,        10,  30,   0,   0,  0, 0,   0,         0, 0, 0, "Resolution", NULL, NULL },
        //{	d_list_proc,        10,  40,  96,  52,  0, 0,   0,         0, 0, 0, resolution_lister, NULL, NULL },
        //{	d_text_proc,       120,  30,   0,   0,  0, 0,   0,         0, 0, 0, "Colour depth", NULL, NULL },
        //{	d_list_proc,       120,  40,  96,  48,  0, 0,   0,         0, 0, 0, colour_depth_lister, NULL, NULL },
        //{	d_text_proc,        10, 104,  96,  48,  0, 0,   0,         0, 0, 0, "Z buffer", NULL, NULL },
        //{	d_list_proc,        10, 114,  96,  48,  0, 0,   0,         0, 0, 0, zbuffer_depth_lister, NULL, NULL },
        //{	d_check_proc,       10, 170,  96,   8,  0, 0,   0,         0, 1, 0, "Windowed", NULL, NULL },
        //{	d_check_proc,       10, 180, 128,   8,  0, 0,   0,D_SELECTED, 1, 0, "Double Buffered", NULL, NULL },
        //{	d_button_proc,     220, 150,  96,  18,  0, 0,   0,    D_EXIT, 0, 0, "Ok", NULL, NULL },
        //{	d_button_proc,     220, 174,  96,  18,  0, 0,   0,    D_EXIT, 0, 0, "Exit", NULL, NULL },
        //{	d_yield_proc,        0,   0,   0,   0,  0, 0,   0,         0, 0, 0, NULL, NULL, NULL },
        //{	NULL,                0,   0,   0,   0,  0, 0,   0,         0, 0, 0, NULL, NULL, NULL }
        //};

        dlg[0] = new DIALOG("d_shadow_box_proc", 0, 0, 320, 200, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);
        dlg[1] = new DIALOG("d_ctext_proc", 160, 10, 0, 0, 0, 0, 0, 0, 0, 0, Marshal.StringToCoTaskMemAnsi("____________"), NULL, NULL);
        dlg[2] = new DIALOG("d_ctext_proc", 160, 8, 0, 0, 0, 0, 0, 0, 0, 0, Marshal.StringToCoTaskMemAnsi("OpenGL Setup"), NULL, NULL);
        dlg[3] = new DIALOG("d_text_proc", 10, 30, 0, 0, 0, 0, 0, 0, 0, 0, Marshal.StringToCoTaskMemAnsi("Resolution"), NULL, NULL);
        dlg[4] = new DIALOG("d_list_proc", 10, 40, 96, 52, 0, 0, 0, 0, 0, 0, Marshal.GetFunctionPointerForDelegate(d_resolution_lister), NULL, NULL);
        dlg[5] = new DIALOG("d_text_proc", 120, 30, 0, 0, 0, 0, 0, 0, 0, 0, Marshal.StringToCoTaskMemAnsi("Colour depth"), NULL, NULL);
        dlg[6] = new DIALOG("d_list_proc", 120, 40, 96, 48, 0, 0, 0, 0, 0, 0, Marshal.GetFunctionPointerForDelegate(d_colour_depth_lister), NULL, NULL);
        dlg[7] = new DIALOG("d_text_proc", 10, 104, 96, 48, 0, 0, 0, 0, 0, 0, Marshal.StringToCoTaskMemAnsi("Z buffer"), NULL, NULL);
        dlg[8] = new DIALOG("d_list_proc", 10, 114, 96, 48, 0, 0, 0, 0, 0, 0, Marshal.GetFunctionPointerForDelegate(d_zbuffer_depth_lister), NULL, NULL);
        dlg[9] = new DIALOG("d_check_proc", 10, 170, 96, 8, 0, 0, 0, 0, 1, 0, Marshal.StringToCoTaskMemAnsi("Windowed"), NULL, NULL);
        dlg[10] = new DIALOG("d_check_proc", 10, 180, 128, 8, 0, 0, 0, D_SELECTED, 1, 0, Marshal.StringToCoTaskMemAnsi("Double Buffered"), NULL, NULL);
        dlg[11] = new DIALOG("d_button_proc", 220, 150, 96, 18, 0, 0, 0, D_EXIT, 0, 0, Marshal.StringToCoTaskMemAnsi("Ok"), NULL, NULL);
        dlg[12] = new DIALOG("d_button_proc", 220, 174, 96, 18, 0, 0, 0, D_EXIT, 0, 0, Marshal.StringToCoTaskMemAnsi("Exit"), NULL, NULL);
        dlg[13] = new DIALOG("d_yield_proc", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);
        dlg[14] = new DIALOG(NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);

        int x;

        if (mode == AGL_WINDOWED)
            dlg[WINDOWED_BOX].flags |= D_SELECTED;

        centre_dialog(dlg);
        set_dialog_color(dlg, makecol(0, 0, 0), makecol(255, 255, 255));

        if (secs != 0)
        {
            textprintf_centre_ex(screen, font, SCREEN_W / 2, SCREEN_H / 2 + 110,
                              makecol(255, 255, 255), 0,
                              string.Format("Frames: {0}, Seconds: {1}, FPS: {2}",
                              frames, secs, (float)frames / (float)secs));
        }

        x = do_dialog(dlg, 4);

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, colour_depths[dlg[COLOUR_LIST].d1].depth);
        allegro_gl_set(AGL_Z_DEPTH, zbuffer_depths[dlg[ZBUFFER_LIST].d1].depth);
        allegro_gl_set(AGL_DOUBLEBUFFER,
                      ((dlg[DOUBLEBUFFER_BOX].flags & D_SELECTED)) != 0 ? 1 : 0);
        allegro_gl_set(AGL_RENDERMETHOD, 1);

        mode = (((dlg[WINDOWED_BOX].flags & D_SELECTED)) != 0
               ? AGL_WINDOWED : AGL_FULLSCREEN);

        allegro_gl_set(mode, TRUE);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH
                                  | AGL_DOUBLEBUFFER | AGL_RENDERMETHOD | mode);

        width = resolutions[dlg[RESOLUTION_LIST].d1].w;
        height = resolutions[dlg[RESOLUTION_LIST].d1].h;

        return (x == BUTTON_OK) ? -1 : 0;
    }

    static void run_demo()
    {
        set_color_depth(16);
        if (set_gfx_mode(GFX_OPENGL, width, height, 0, 0) < 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\nAllegro GL error : {1}\n", allegro_error, allegro_gl_error));
            return;
        }

        install_keyboard();

        LOCK_FUNCTION(_secs_timer);
        LOCK_VARIABLE(secs);

        OpenGL.glClearColor(0, 0, 0, 0);
        OpenGL.glShadeModel(OpenGL.GL_FLAT);
        OpenGL.glPolygonMode(OpenGL.GL_FRONT_AND_BACK, OpenGL.GL_FILL);
        OpenGL.glPolygonMode(OpenGL.GL_BACK, OpenGL.GL_POINTS);
        OpenGL.glEnable(OpenGL.GL_DEPTH_TEST);
        OpenGL.glCullFace(OpenGL.GL_BACK);
        OpenGL.glEnable(OpenGL.GL_CULL_FACE);

        install_int(secs_timer, 1000);

        do
        {
            keyboard();
            rest(2);
        } while (!key[KEY_ESC]);

        remove_int(secs_timer);

        remove_keyboard();
    }

    static int Main()
    {
        int ok;
        allegro_init();
        install_timer();

        do
        {
            set_color_depth(8);
            if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0)
            {
                allegro_message(string.Format("Error setting plain graphics mode:\n{0}\n", allegro_error));
                return -1;
            }

            install_allegro_gl();

            install_keyboard();
            install_mouse();
            ok = setup();
            remove_keyboard();
            remove_mouse();

            if (ok != 0) run_demo();

            remove_allegro_gl();
        } while (ok != 0);

        return 0;
    }
}