﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

using allegro;

namespace alleggl
{
    public class AllegGL : Allegro
    {
        public static GFX_DRIVER gfx_allegro_gl_windowed
        {
            get
            {
                return new GFX_DRIVER(Marshal.ReadIntPtr(GetAddress("gfx_allegro_gl_windowed")));
            }
        }

        public static IntPtr our_driver_list
        {
            get
            {
                IntPtr address = GetAddress("our_driver_list");
                return Marshal.ReadIntPtr(GetAddress("our_driver_list"));
            }
        }

#if DEBUG
        new public static int set_gfx_mode(int card, int w, int h, int v_w, int v_h)
        {
            return AllegroAPI.set_gfx_mode(card, w, h, v_w, v_h);
        }
#endif

        #region Constants

        public const int AGL_VERSION = 0;            ///< Major version number
        public const int AGL_SUB_VERSION = 4;            ///< Minor version number
        public const int AGL_WIP_VERSION = 3;            ///< Work-In-Progress version number
        public const string AGL_VERSION_STR = "0.4.3";      ///< Version description string

        protected static readonly int GFX_OPENGL_WINDOWED = AL_ID('O', 'G', 'L', 'W');
        protected static readonly int GFX_OPENGL_FULLSCREEN = AL_ID('O', 'G', 'L', 'F');
        protected static readonly int GFX_OPENGL = AL_ID('O', 'G', 'L', 'D');

        public const int AGL_ALLEGRO_FORMAT = 0x00000001;

        public const int AGL_RED_DEPTH = 0x00000002;

        public const int AGL_GREEN_DEPTH = 0x00000004;

        public const int AGL_BLUE_DEPTH = 0x00000008;

        public const int AGL_ALPHA_DEPTH = 0x00000010;

        public const int AGL_COLOR_DEPTH = 0x00000020;

        public const int AGL_ACC_RED_DEPTH = 0x00000040;

        public const int AGL_ACC_GREEN_DEPTH = 0x00000080;

        public const int AGL_ACC_BLUE_DEPTH = 0x00000100;

        public const int AGL_ACC_ALPHA_DEPTH = 0x00000200;

        public const int AGL_DOUBLEBUFFER = 0x00000400;

        public const int AGL_STEREO = 0x00000800;

        public const int AGL_AUX_BUFFERS = 0x00001000;

        public const int AGL_Z_DEPTH = 0x00002000;

        public const int AGL_STENCIL_DEPTH = 0x00004000;

        public const int AGL_WINDOW_X = 0x00008000;

        public const int AGL_WINDOW_Y = 0x00010000;

        public const int AGL_RENDERMETHOD = 0x00020000;

        public const int AGL_FULLSCREEN = 0x00040000;

        public const int AGL_WINDOWED = 0x00080000;

        public const int AGL_VIDEO_MEMORY_POLICY = 0x00100000;

        public const int AGL_SAMPLE_BUFFERS = 0x00200000;

        public const int AGL_SAMPLES = 0x00400000;

        public const int AGL_FLOAT_COLOR = 0x00800000;

        public const int AGL_FLOAT_Z = 0x01000000;

        public const int AGL_CONFIG_RESRVED = 0xA000000;

        public const int AGL_DONTCARE = 0; ///< Ignore these settings
        public const int AGL_SUGGEST = -1; ///< Prefer the assigned values for these settings
        public const int AGL_REQUIRE = -2; ///< Reject other values for these settings

        public const int AGL_KEEP = 1; ///< Keep internal texture in video memory
        public const int AGL_RELEASE = 2; ///< Release video memory occupied by internal texture


        /** AllegroGL will generate mipmaps for this texture.
         */
        public const int AGL_TEXTURE_MIPMAP = 0x01;

        /** Tell AllegroGL that the bitmap had an alpha channel, so it should be
         *  preserved when generating the texture.
         */
        public const int AGL_TEXTURE_HAS_ALPHA = 0x02;

        /** Flip the texture on the x-axis. OpenGL uses the bottom-left corner of
         *  the texture as (0,0), so if you need your texture to be flipped to make
         *  (0,0) the top-left corner, you need to use this flag.
         */
        public const int AGL_TEXTURE_FLIP = 0x04;

        /** Generate an alpha channel for this texture, based on the Allegro mask color.
         *  Make sure the target format supports an alpha channel.
         */
        public const int AGL_TEXTURE_MASKED = 0x08;

        /** Tell AllegroGL to allow rescaling of the bitmap. By default, AllegroGL
         *  will not rescale the bitmap to fit into a texture. You can override this
         *  behavior by using this flag.
         */
        public const int AGL_TEXTURE_RESCALE = 0x10;


        /** Tell AllegroGL that the specified BITMAP is an 8-bpp alpha-only BITMAP.
         */
        public const int AGL_TEXTURE_ALPHA_ONLY = 0x20;

        #endregion

        public static string allegro_gl_error
        {
            get
            {
                return Marshal.PtrToStringAnsi(GetAddress("allegro_gl_error"));
            }
        }

        #region Core routines

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int install_allegro_gl();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void remove_allegro_gl();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_flip();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float allegro_gl_opengl_version();

        public static int allegro_gl_begin() { return 0; }

        public static int allegro_gl_end() { return 0; }

        #endregion

        #region Mode selection functions

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_clear_settings();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_set(int option, int value);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_get(int option);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_save_settings();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_load_settings();

        #endregion

        #region Bitmap Routines

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_set_video_bitmap_color_depth(int bpp);

        #endregion

        #region Texture Routines

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_use_mipmapping(int enable);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_use_alpha_channel(int enable);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_flip_texture(int enable);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_check_texture(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_check_texture_ex(int flags, IntPtr bmp, int internal_format);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_get_texture_format(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_set_texture_format(int format);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_get_bitmap_type(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_get_bitmap_color_format(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern uint allegro_gl_make_texture(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern uint allegro_gl_make_masked_texture(IntPtr bmp);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern uint allegro_gl_make_texture_ex(int flags, IntPtr bmp, int internal_format);

        #endregion

        #region Allegro Interfacing

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_set_allegro_mode();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_unset_allegro_mode();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_set_projection();

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_unset_projection();

        #endregion

        #region Text drawing and fonts.

        public const int AGL_FONT_TYPE_DONT_CARE = -1;

        public const int AGL_FONT_TYPE_BITMAP = 0;

        public const int AGL_FONT_TYPE_OUTLINE = 1;

        public const int AGL_FONT_TYPE_TEXTURED = 2;

        public const int AGL_FONT_STYLE_BOLD = 1;

        public const int AGL_FONT_STYLE_BLACK = 2;

        public const int AGL_FONT_STYLE_ITALIC = 4;

        public const int AGL_FONT_STYLE_UNDERLINE = 8;

        public const int AGL_FONT_STYLE_STRIKEOUT = 16;

        public const int AGL_FONT_STYLE_ANTI_ALIASED = 32;

        public const int AGL_FONT_POLYGONS = 1;

        public const int AGL_FONT_LINES = 2;

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_printf(IntPtr f, float x, float y, float z, int color, string format);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int allegro_gl_printf_ex(IntPtr f, float x, float y, float z, string format);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr allegro_gl_convert_allegro_font(IntPtr f, int type, float scale);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr allegro_gl_convert_allegro_font_ex(IntPtr f, int type, float scale, int format);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_set_font_generation_mode(int mode);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr allegro_gl_load_system_font(string name, int style, int w, int h);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern IntPtr allegro_gl_load_system_font_ex(string name, int type, int style, int w, int h, float depth, int start, int end);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void allegro_gl_destroy_font(IntPtr f);

        //[DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        //public static extern size_t allegro_gl_list_font_textures(FONT f, uint *ids, size_t max_num_id));

        #endregion

        #region Allegro-compatible GUI routines

        //[DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        //public static extern int algl_do_dialog(IntPtr dialog, int focus_obj);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int algl_popup_dialog(IntPtr dialog, int focus_obj);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void algl_draw_mouse();

        //        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        //public static extern void algl_set_mouse_drawer(void (*user_draw_mouse)(void)));

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int algl_alert(string s1, string s2, string s3, string b1, string b2, int c1, int c2);

        [DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int algl_alert3(string s1, string s2, string s3, string b1, string b2, string b3, int c1, int c2, int c3);

        //[DllImport(@"agl.dll", CallingConvention = CallingConvention.Cdecl)]
        //public static extern int d_algl_viewport_proc(int msg, IntPtr d, int c);

        #endregion
    }
}
