﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

using alleggl;
using System.Diagnostics;

namespace alleggl_test
{
    public class Test : AllegGL
    {
        const int WINDOW_W = 640;
        const int WINDOW_H = 480;

        static int Main()
        {
            uint pid;

            allegro_init();
            install_allegro_gl();
            install_keyboard();

            allegro_gl_clear_settings();
            allegro_gl_set(AGL_COLOR_DEPTH, 32);
            allegro_gl_set(AGL_DOUBLEBUFFER, 1);
            allegro_gl_set(AGL_Z_DEPTH, 32);
            allegro_gl_set(AGL_WINDOWED, TRUE);
            allegro_gl_set(AGL_RENDERMETHOD, 1);
            allegro_gl_set(AGL_SAMPLES, 4);
            allegro_gl_set(AGL_SAMPLE_BUFFERS, 1);
            allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER
                                      | AGL_RENDERMETHOD | AGL_Z_DEPTH | AGL_WINDOWED
                                      | AGL_SAMPLES | AGL_SAMPLE_BUFFERS);

            if (set_gfx_mode(GFX_OPENGL, WINDOW_W, WINDOW_H, 0, 0) != 0)
            {
                allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                                "Allegro GL error : {1}\n",
                                allegro_error, allegro_gl_error));
                return -1;
            }

            string[] extensions = OpenGL.glGetString(OpenGL.GL_EXTENSIONS).ToString().Split(new char[] { ' ' });
            //allegro_message(string.Join("\n", extensions));
            //allegro_message("Supported extensions: " + extensions.Length);

            if (AGL_EXTENSION_LIST_GL.allegro_gl_extensions_GL.ARB_multisample != 0)
            {
                OpenGL.glEnable(OpenGLExt.GL_MULTISAMPLE_ARB);
            }

            if (AGL_EXTENSION_LIST_GL.allegro_gl_extensions_GL.ARB_vertex_program == 0)
            {
                allegro_message("This example requires a video card that supports " +
                                " the ARB_vertex_program extension.\n");
                return -1;
            }

            OpenGL.glEnable(OpenGL.GL_DEPTH_TEST);
            OpenGL.glShadeModel(OpenGL.GL_SMOOTH);
            OpenGL.glHint(OpenGL.GL_PERSPECTIVE_CORRECTION_HINT, OpenGL.GL_NICEST);
            OpenGL.glPolygonMode(OpenGL.GL_FRONT_AND_BACK, OpenGL.GL_LINE);
            OpenGL.glDisable(OpenGL.GL_CULL_FACE);

            /* Setup projection and modelview matrices */
            OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
            OpenGL.glLoadIdentity();
            OpenGLU.gluPerspective(45.0, WINDOW_W / (float)WINDOW_H, 0.1, 100.0);

            OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
            OpenGL.glLoadIdentity();

            /* Position the camera to look at our mesh from a distance */
            OpenGLU.gluLookAt(0.0f, 20.0f, -45.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0);

            //if (allegro_gl_extensions_GL.NV_vertex_program2_option) {
            //    OpenGL.glProgramStringARB(OpenGL.GL_VERTEX_PROGRAM_ARB, OpenGL.GL_PROGRAM_FORMAT_ASCII_ARB,
            //                       strlen(program_nv), program_nv);
            //}
            //else {
            //    OpenGL.glProgramStringARB(OpenGL.GL_VERTEX_PROGRAM_ARB, OpenGL.GL_PROGRAM_FORMAT_ASCII_ARB,
            //                       strlen(program), program);
            //}

            /* Check for errors */
            if (OpenGL.glGetError() != 0)
            {
                string pgm = string.Empty;
                //string pgm =
                //                     allegro_gl_extensions_GL.NV_vertex_program2_option
                //                   ? program_nv : program;
                int error_pos = 0;
                string error_str = OpenGL.glGetString(OpenGLExt.GL_PROGRAM_ERROR_STRING_ARB).ToString();
                //OpenGL.glGetIntegerv(OpenGL.GL_PROGRAM_ERROR_POSITION_ARB, &error_pos);

                allegro_message(string.Format("Error compiling the vertex program:\n{0}\n\nat " +
                                "character: {1}\n{2}\n", error_str, (int)error_pos,
                                pgm + error_pos));
                Debug.WriteLine(string.Format("Error compiling the vertex program:\n{0}\n\nat " +
                      "character: {1}\n{2}\n", error_str, (int)error_pos,
                      pgm + error_pos));
                return -1;
            }


            while (!key[KEY_ESC])
            {
                allegro_gl_flip();
            }

            //OpenGL.glDeleteProgramsARB(1, ref pid);

            return 0;
        }
    }
}
