﻿using System;
using System.Collections.Generic;
using System.Text;

using alleggl;

public class test : AllegGL
{
    struct _camera
    {
        public double xangle, yangle, zangle;
        public double dist;

        public _camera(double xangle, double yangle, double zangle, double dist)
        {
            this.xangle = xangle;
            this.yangle = yangle;
            this.zangle = zangle;
            this.dist = dist;
        }
    }

    static _camera camera = new _camera(
        0.0, 0.0, 0.0,
        20.0);

    static double angle_speed = 5.0;
    static double dist_speed = 1.0;

    static int frames = 0;
    static volatile int secs;

    static TimerHandler _secs_timer = new TimerHandler(secs_timer);
    static void secs_timer()
    {
        secs++;
    }
    //END_OF_FUNCTION(secs_timer);

    static void set_camera_position()
    {
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 40.0);
        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
    }

    static void keyboard()
    {
        if (key[KEY_LEFT]) camera.yangle += angle_speed;
        if (key[KEY_RIGHT]) camera.yangle -= angle_speed;

        if (key[KEY_UP]) camera.xangle += angle_speed;
        if (key[KEY_DOWN]) camera.xangle -= angle_speed;

        if (key[KEY_PGUP]) camera.dist -= dist_speed;
        if (key[KEY_PGDN]) camera.dist += dist_speed;

        set_camera_position();
        display();
    }

    static void display()
    {
        // Clear the RGB buffer and the depth buffer
        OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);

        // Set the modelview matrix to be the identity matrix
        OpenGL.glLoadIdentity();

        //Set the camera
        OpenGL.glTranslatef(0f, 0f, (float)-camera.dist);
        OpenGL.glRotatef((float)camera.xangle, 1f, 0f, 0f);
        OpenGL.glRotatef((float)camera.yangle, 0f, 1f, 0f);
        OpenGL.glRotatef((float)camera.zangle, 0f, 0f, 1f);

        // Save the camera matrix
        OpenGL.glPushMatrix();

        // Translate and rotate the object
        OpenGL.glTranslatef(-2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(-30f, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(30f, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(30f, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(1.0f, 0.0f, 1.0f);

        // Draw the sides of the three-sided pyramid
        OpenGL.glBegin(OpenGL.GL_TRIANGLE_FAN);
        OpenGL.glVertex3d(0, 4, 0);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 1.0f, 1.0f);

        // Draw the base of the pyramid
        OpenGL.glBegin(OpenGL.GL_TRIANGLES);
        OpenGL.glVertex3d(0, -4, -4);
        OpenGL.glVertex3d(4, -4, 4);
        OpenGL.glVertex3d(-4, -4, 4);
        OpenGL.glEnd();

        // Get the camera matrix back
        OpenGL.glPopMatrix();

        // Translate for the cube
        OpenGL.glTranslatef(2.5f, 0.0f, 0.0f);
        OpenGL.glRotatef(45f, 1.0f, 0.0f, 0.0f);
        OpenGL.glRotatef(45f, 0.0f, 1.0f, 0.0f);
        OpenGL.glRotatef(45f, 0.0f, 0.0f, 1.0f);

        OpenGL.glColor3f(0.0f, 1.0f, 0.0f);

        // Draw the sides of the cube
        OpenGL.glBegin(OpenGL.GL_QUAD_STRIP);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glVertex3d(-3, -3, 3);
        OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glEnd();

        OpenGL.glColor3f(0.0f, 0.0f, 1.0f);

        // Draw the top and bottom of the cube
        OpenGL.glBegin(OpenGL.GL_QUADS);
        OpenGL.glVertex3d(-3, -3, -3);
        OpenGL.glVertex3d(3, -3, -3);
        OpenGL.glVertex3d(3, -3, 3);
        OpenGL.glVertex3d(-3, -3, 3);

        OpenGL.glVertex3d(-3, 3, -3);
        OpenGL.glVertex3d(-3, 3, 3);
        OpenGL.glVertex3d(3, 3, 3);
        OpenGL.glVertex3d(3, 3, -3);
        OpenGL.glEnd();

        OpenGL.glFlush();

        allegro_gl_flip();

        frames++;
    }

    static int Main()
    {
        allegro_init();

        install_allegro_gl();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_Z_DEPTH, 24);
        allegro_gl_set(AGL_FULLSCREEN, TRUE);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH
                      | AGL_DOUBLEBUFFER | AGL_FULLSCREEN);

        if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) < 0)
        {
            allegro_message(string.Format("Error setting OpenGL graphics mode:\n{0}\n" +
                             "Allegro GL error : {1}\n",
                             allegro_error, allegro_gl_error));
            return -1;
        }

        install_keyboard();
        install_timer();

        LOCK_FUNCTION(_secs_timer);
        LOCK_VARIABLE(secs);

        OpenGL.glShadeModel(OpenGL.GL_FLAT);
        OpenGL.glEnable(OpenGL.GL_DEPTH_TEST);
        OpenGL.glCullFace(OpenGL.GL_BACK);
        OpenGL.glEnable(OpenGL.GL_CULL_FACE);

        install_int(_secs_timer, 1000);

        do
        {
            keyboard();
        } while (!key[KEY_ESC]);

        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

        allegro_message(string.Format("Frames: {0}, Seconds: {1}, FPS: {2}\n",
                        frames, secs, (float)frames / (float)secs));

        return 0;
    }
}