﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.Runtime.InteropServices;
using System.Text;

using allegro;
using alleggl;

public class fonttest : AllegGL
{
    /* Make it compile with Allegro 4.2.0, which is missing make_trans_font. */
    //#if ALLEGRO_VERSION == 4 && ALLEGRO_SUB_VERSION == 2 && ALLEGRO_WIP_VERSION == 0
    //static void make_trans_font(FONT *f) {(void)f;}
    //#endif

    const int OPENGL_FORMATS = 6;
    const int FONTS_COUNT = 4;

    static int Main()
    {
        /* The fonts. */
        FONT[] allegro_font = new FONT[OPENGL_FORMATS];
        //PALETTE[] pal = new PALETTE[FONTS_COUNT];
        PALETTE[] pal = { new PALETTE(), new PALETTE(), new PALETTE(), new PALETTE() };
        FONT[] allegrogl_font = new FONT[FONTS_COUNT * OPENGL_FORMATS];
        string[] font_file = { "a32.tga", "a24.tga", "a8.bmp", "a1.bmp" };
        string[] font_name = { "32 bit", "24 bit", "8 bit", "1 bit" };
        /* OpenGL texture formats to test. */
        int[] opengl_format = {
        (int)OpenGL.GL_RGBA, (int)OpenGL.GL_RGB, (int)OpenGL.GL_ALPHA, (int)OpenGL.GL_LUMINANCE,
        (int)OpenGL.GL_INTENSITY, (int)OpenGL.GL_LUMINANCE_ALPHA};
        string[,] opengl_format_name = {
            {"RGBA", ""}, {"RGB", ""}, {"ALPHA", ""}, {"LUMINANCE", ""},
            {"INTENSITY", ""}, {"LUMINANCE", "_ALPHA"}
        };
        /* Make our window have just the right size. */
        int w = 80 + OPENGL_FORMATS * 96;
        int h = 32 + FONTS_COUNT * 80;
        int x, y, i;

        allegro_init();
        install_timer();
        install_allegro_gl();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH);
        set_gfx_mode(GFX_OPENGL_WINDOWED, w, h, 0, 0);
        install_keyboard();

        allegro_gl_set_allegro_mode();

        /* Load the fonts. */
        for (i = 0; i < FONTS_COUNT; i++)
        {
            allegro_font[i] = load_font(font_file[i], pal[i], NULL);
            if (!allegro_font[i])
            {
                set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                allegro_message(string.Format("Unable to load \"{0}\".\n", font_file[i]));
                return -1;
            }
            transpose_font(allegro_font[i], 'a' - ' ');
        }

        make_trans_font(allegro_font[0]);
        set_trans_blender(0, 0, 0, 0);

        /* Convert the fonts to all the format combination we want to test. */
        for (i = 0; i < FONTS_COUNT * OPENGL_FORMATS; i++)
        {
            select_palette(pal[i % FONTS_COUNT]);

            allegrogl_font[i] = allegro_gl_convert_allegro_font_ex(
                allegro_font[i % FONTS_COUNT],
                AGL_FONT_TYPE_TEXTURED, 1, opengl_format[i / FONTS_COUNT]);
        }

        while (!key[KEY_ESC])
        {
            int s = 16;
            OpenGL.glClearColor(1, 1, 1, 1);
            OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT);

            /* Draw background pattern. */
            for (y = 32; y < h; y += s)
            {
                for (x = 80; x < w; x += s)
                {
                    int sx = (x / s) & 1;
                    int sy = (y / s) & 1;
                    float c = sx ^ sy;
                    OpenGL.glColor3f(0.2f + c * 0.6f, 0.2f + c * 0.6f, c);
                    OpenGL.glBegin(OpenGL.GL_QUADS);
                    OpenGL.glVertex2d(x, y);
                    OpenGL.glVertex2d(x + s, y);
                    OpenGL.glVertex2d(x + s, y + s);
                    OpenGL.glVertex2d(x, y + s);
                    OpenGL.glEnd();
                }
            }

            OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
            OpenGL.glEnable(OpenGL.GL_BLEND);

            /* Draw left info text. */
            for (y = 0; y < FONTS_COUNT; y++)
            {
                OpenGL.glBlendFunc(OpenGL.GL_ONE, OpenGL.GL_ZERO);
                textprintf_ex(screen, font, 4, 32 + y * 80,
                    makecol(0, 0, 0), -1, string.Format("{0}", font_name[y]));
            }

            /* Columns are texture formats, rows are font formats. */
            i = 0;
            for (x = 0; x < OPENGL_FORMATS; x++)
            {
                int j;
                /* Draw top info text. */
                OpenGL.glBlendFunc(OpenGL.GL_ONE, OpenGL.GL_ZERO);
                for (j = 0; j < 2; j++)
                    textprintf_ex(screen, font, 80 + x * 96, 4 + 16 * j,
                        makecol(0, 0, 0), -1, string.Format("{0}", opengl_format_name[x, j]));

                /* Draw the example glyph for the current cell. */
                for (y = 0; y < FONTS_COUNT; y++)
                {
                    OpenGL.glBlendFunc(OpenGL.GL_SRC_ALPHA, OpenGL.GL_ONE_MINUS_SRC_ALPHA);
                    OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);
                    OpenGL.glPushMatrix();
                    OpenGL.glTranslatef(80 + x * 96, 32 + y * 80, 0);
                    OpenGL.glScalef(1, -1, 1);
                    OpenGL.glColor4f(1, 1, 1, 1);
                    allegro_gl_printf_ex(allegrogl_font[i++], 0, 0, 0, "a");
                    OpenGL.glPopMatrix();

                }
            }

            OpenGL.glDisable(OpenGL.GL_TEXTURE_2D);
            OpenGL.glDisable(OpenGL.GL_BLEND);

            allegro_gl_flip();
            /* Update about 60 times / second. */
            rest(1000 / 60);
        }
        return 0;
    }
}