﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using allegro;
using alleggl;

public class extext : AllegGL
{
    const float M_PI = 3.1415f;

    const int NUM_STRINGS = 3;
    const string STRING = "Hello World!";

    const string STRING0 = ("AllegroGL  v" + AGL_VERSION_STR);
    const string STRING1 = "Text Drawing";
    const string STRING2 = "And Font Loading";
    const string STRING3 = "Example Program";
    const string STRING4 = "See Our Webpage At:";


    const string URL = "http://allegrogl.sourceforge.net/";

    static volatile int chrono = 0;
    //static volatile double angle = 0.0;
    static double angle = 0.0;

    public struct COORD
    {
        public float x, y, z;
        public int c;
    }
    static COORD[] coord = new COORD[NUM_STRINGS];


    static TimerHandler _the_timer = new TimerHandler(the_timer);
    static void the_timer()
    {
        chrono++;
        angle += 1.0 / 400.0;

        if (angle > M_PI)
            angle -= 2 * M_PI;
    }

    static int Main()
    {
        FONT lucidia_fnt;
        FONT allegro_fnt;
        DATAFILE dat;

        string _string = STRING;
        int i;

        allegro_init();
        install_allegro_gl();
        install_timer();

        LOCK_FUNCTION(_the_timer);
        LOCK_VARIABLE(chrono);

        install_int(the_timer, 2);

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_Z_DEPTH, 24);
        allegro_gl_set(AGL_WINDOWED, TRUE);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_RENDERMETHOD, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER
                     | AGL_RENDERMETHOD | AGL_Z_DEPTH | AGL_WINDOWED);

        if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) != 0)
        {
            allegro_message("Error initializing OpenGL!\n");
            return -1;
        }

        install_keyboard();


        /* Load 2 copies of the datafile */
        dat = load_datafile("lucidia.dat");

        if (!dat)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to load lucidia.dat\n");
            return -2;
        }

        lucidia_fnt = allegro_gl_convert_allegro_font((FONT)dat[0].dat,
                                                      AGL_FONT_TYPE_TEXTURED, 16.0f);

        if (!lucidia_fnt)
        {
            unload_datafile(dat);
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to convert font!\n");
            return -3;
        }

        allegro_fnt = allegro_gl_convert_allegro_font(font,
                                                      AGL_FONT_TYPE_TEXTURED, 16.0f);

        if (!allegro_fnt)
        {
            allegro_gl_destroy_font(lucidia_fnt);
            unload_datafile(dat);
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to convert font!\n");
            return -4;
        }


        //srand(time(NULL));
        Random random = new Random();


        for (i = 0; i < NUM_STRINGS; i++)
        {
            coord[i].z = 0;
            coord[i].c = 0;
        }
        i = 0;

        /* Start nice text demo */

        /* Setup OpenGL like we want */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);
        OpenGL.glEnable(OpenGL.GL_BLEND);

        OpenGL.glViewport(0, 0, SCREEN_W, SCREEN_H);
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glFrustum(-1.0, 1.0, -1.0, 1.0, 1, 60.0);

        /* Set culling mode - not that we have anything to cull */
        OpenGL.glEnable(OpenGL.GL_CULL_FACE);
        OpenGL.glFrontFace(OpenGL.GL_CCW);

        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);

        do
        {
            int c;

            /* Update rotation angle of text */
            OpenGL.glLoadIdentity();

            OpenGL.glTranslatef(0, 0, -30);
            OpenGL.glRotatef(-45, 1, 0, 0);
            OpenGL.glRotatef(-30, 0, 1, 0);

            /* Clear the screen and set a nice blender mode */
            OpenGL.glClear(OpenGL.GL_COLOR_BUFFER_BIT | OpenGL.GL_DEPTH_BUFFER_BIT);
            OpenGL.glBlendFunc(OpenGL.GL_ONE, OpenGL.GL_ONE_MINUS_SRC_COLOR);

            /* Print the text wheel */
            for (i = 0; i < NUM_STRINGS; i++)
            {
                allegro_gl_printf(lucidia_fnt, coord[i].x, coord[i].y, coord[i].z,
                                  coord[i].c, _string);
            }
            /* Update the text wheel's position */
            for (i = 0; i < NUM_STRINGS; i++)
            {
                int r, g, b;
                float angle2 = (float)angle + i * M_PI * 2 / NUM_STRINGS;
                coord[i].x = 10 * (float)Math.Cos(angle2) - 10;
                coord[i].y = 10 * (float)Math.Sin(angle2);
                angle2 = angle2 * 180.0f / M_PI;
                //#if ((((ALLEGRO_VERSION) << 16) | ((ALLEGRO_SUB_VERSION) << 8) | (ALLEGRO_WIP_VERSION)) == 0x40200)
                //            /* Work around an Allegro bug that's only in 4.2.0 */
                //            while (angle2 > 360.0f) angle2 -= 360.0f;
                //            while (angle2 < 0)      angle2 += 360.0f;
                //#endif			
                hsv_to_rgb(angle2, 1, 1, out r, out g, out b);
                coord[i].c = makeacol(r, g, b, 255);
            }
            /* Draw "AllegroGL" */
            OpenGL.glLoadIdentity();
            c = MID(0, (int)(255 - chrono / 100), 255);
            allegro_gl_printf(allegro_fnt, -((STRING0.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 0, makecol(c, c, c), STRING0);
            c = MID(0, (int)(255 - chrono / 100) + 24, 255);
            allegro_gl_printf(allegro_fnt, -((STRING1.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 12, makecol(c, c, c), STRING1);
            c = MID(0, (int)(255 - chrono / 100) + 48, 255);
            allegro_gl_printf(allegro_fnt, -((STRING2.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 24, makecol(c, c, c), STRING2);
            c = MID(0, (int)(255 - chrono / 100) + 72, 255);
            allegro_gl_printf(allegro_fnt, -((STRING3.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 36, makecol(c, c, c), STRING3);
            c = MID(0, (int)(255 - chrono / 100) + 96, 255);
            allegro_gl_printf(allegro_fnt, -((STRING4.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 48, makecol(c, c, c), STRING4);
            c = MID(0, (int)(255 - chrono / 100) + 120, 255);
            allegro_gl_printf(allegro_fnt, -((URL.Length) * 1 / 2.0f) / 2,
                            -3.0f, -chrono / 200.0f + 60, makecol(c, c, c), URL);

            allegro_gl_flip();

            rest(2);

        } while (!key[KEY_ESC]);

        return 0;
    }
}
