﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.Runtime.InteropServices;
using System.Text;

using allegro;
using alleggl;

public class exalpfnt : AllegGL
{
    /* font test -- based on extext */

    /* Specifically, this tests alpha fonts blending into backgrounds compared
     * to solid text with transparent background.
     */

    static int Main()
    {

        FONT demofont;
        DATAFILE dat;

        allegro_init();
        install_allegro_gl();

        allegro_gl_clear_settings();
        allegro_gl_set(AGL_COLOR_DEPTH, 32);
        allegro_gl_set(AGL_WINDOWED, TRUE);
        allegro_gl_set(AGL_DOUBLEBUFFER, 1);
        allegro_gl_set(AGL_SUGGEST, AGL_DOUBLEBUFFER | AGL_COLOR_DEPTH
                     | AGL_WINDOWED);

        if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) != 0)
        {
            allegro_message("Error initializing OpenGL!\n");
            return -1;
        }

        install_keyboard();
        install_timer();

        /* Load font palette first, then font itself */
        dat = load_datafile_object("demofont.dat", "PAL");
        if (!dat)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Error loading demofont.dat#PAL\n");
            return -1;
        }
        set_palette((RGB)dat.dat);
        unload_datafile_object(dat);

        dat = load_datafile_object("demofont.dat", "FONT");
        if (!dat)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Error loading demofont.dat#FONT\n");
            return -1;
        }
        demofont = allegro_gl_convert_allegro_font_ex((FONT)dat.dat,
                                           AGL_FONT_TYPE_TEXTURED, (float)16.0, (int)OpenGL.GL_ALPHA8);
        unload_datafile_object(dat);

        if (!demofont)
        {
            set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
            allegro_message("Unable to convert font!\n");
            return -1;
        }


        /* Setup OpenGL the way we want */
        OpenGL.glEnable(OpenGL.GL_TEXTURE_2D);

        OpenGL.glViewport(0, 0, SCREEN_W, SCREEN_H);
        OpenGL.glMatrixMode(OpenGL.GL_PROJECTION);
        OpenGL.glLoadIdentity();
        OpenGL.glOrtho(0, 1, 0, 1, -1, 1);

        OpenGL.glMatrixMode(OpenGL.GL_MODELVIEW);

        do
        {
            int x, y;
            OpenGL.glLoadIdentity();

            /* Draw the background */
            for (y = 0; y < 4; y++)
            {
                for (x = 0; x < 4; x++)
                {
                    OpenGL.glColor3f((y & 1), (x & 1), ((y & 2) ^ (x & 2)) / 2);
                    OpenGL.glBegin(OpenGL.GL_QUADS);
                    OpenGL.glVertex2f(x * 0.25f, y * 0.25f);
                    OpenGL.glVertex2f(x * 0.25f, (y + 1) * 0.25f);
                    OpenGL.glVertex2f((x + 1) * 0.25f, (y + 1) * 0.25f);
                    OpenGL.glVertex2f((x + 1) * 0.25f, y * 0.25f);
                    OpenGL.glEnd();
                }
            }

            /* Draw the text on top */
            OpenGL.glScalef(0.1f, 0.1f, 0.1f);

            /* First, draw the text alpha blended */
            OpenGL.glEnable(OpenGL.GL_BLEND);
            OpenGL.glBlendFunc(OpenGL.GL_SRC_ALPHA, OpenGL.GL_ONE_MINUS_SRC_ALPHA);
            allegro_gl_printf(demofont, 1, 8, 0, makeacol(255, 255, 255, 255),
                             "Hello World!");
            OpenGL.glBlendFunc(OpenGL.GL_ONE, OpenGL.GL_ZERO);
            OpenGL.glDisable(OpenGL.GL_BLEND);

            /* Now just draw it solid with transparent background */
            OpenGL.glEnable(OpenGL.GL_ALPHA_TEST);
            OpenGL.glAlphaFunc(OpenGL.GL_GREATER, 0.5f);
            allegro_gl_printf(demofont, 1, 5, 0, makeacol(255, 255, 255, 255),
                             "Hello World!");
            OpenGL.glDisable(OpenGL.GL_ALPHA_TEST);

            allegro_gl_flip();
            rest(2);

        } while (!keypressed());

        /* Clean up and exit */
        allegro_gl_destroy_font(demofont);
        Debug.WriteLine("Font Destroyed");

        return 0;
    }
}