﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace alleggl
{
    public class OpenGL
    {
        #region Datatypes

        //typedef unsigned int    GLenum;
        // uint
        //typedef unsigned char   GLboolean;
        // byte
        //typedef unsigned int    GLbitfield;
        // uint
        //typedef void            GLvoid;
        //typedef signed char     GLbyte;         /* 1-byte signed */
        // sbyte
        //typedef short           GLshort;        /* 2-byte signed */
        //typedef int             GLint;          /* 4-byte signed */
        //typedef unsigned char   GLubyte;        /* 1-byte unsigned */
        // byte
        //typedef unsigned short  GLushort;       /* 2-byte unsigned */
        //typedef unsigned int    GLuint;         /* 4-byte unsigned */
        // uint
        //typedef int             GLsizei;        /* 4-byte signed */
        // int
        //typedef float           GLfloat;        /* single precision float */
        // float
        //typedef float           GLclampf;       /* single precision float in [0,1] */
        // float
        //typedef double          GLdouble;       /* double precision float */
        // double
        //typedef double          GLclampd;       /* double precision float in [0,1] */

        #endregion

        #region Constants

        public const uint GL_VERSION_1_1 = 1;
        public const uint GL_VERSION_1_2 = 1;
        public const uint GL_VERSION_1_3 = 1;
        public const uint GL_ARB_imaging = 1;

        /* Boolean values */

        public const uint GL_FALSE = 0x0;
        public const uint GL_TRUE = 0x1;

        /* Data types */

        public const uint GL_BYTE = 0x1400;
        public const uint GL_UNSIGNED_BYTE = 0x1401;
        public const uint GL_SHORT = 0x1402;
        public const uint GL_UNSIGNED_SHORT = 0x1403;
        public const uint GL_INT = 0x1404;
        public const uint GL_UNSIGNED_INT = 0x1405;
        public const uint GL_FLOAT = 0x1406;
        public const uint GL_DOUBLE = 0x140A;
        public const uint GL_2_BYTES = 0x1407;
        public const uint GL_3_BYTES = 0x1408;
        public const uint GL_4_BYTES = 0x1409;

        /* Primitives */

        public const uint GL_POINTS = 0x0000;
        public const uint GL_LINES = 0x0001;
        public const uint GL_LINE_LOOP = 0x0002;
        public const uint GL_LINE_STRIP = 0x0003;
        public const uint GL_TRIANGLES = 0x0004;
        public const uint GL_TRIANGLE_STRIP = 0x0005;
        public const uint GL_TRIANGLE_FAN = 0x0006;
        public const uint GL_QUADS = 0x0007;
        public const uint GL_QUAD_STRIP = 0x0008;
        public const uint GL_POLYGON = 0x0009;

        /* Vertex Arrays */

        public const uint GL_VERTEX_ARRAY = 0x8074;
        public const uint GL_NORMAL_ARRAY = 0x8075;
        public const uint GL_COLOR_ARRAY = 0x8076;
        public const uint GL_INDEX_ARRAY = 0x8077;
        public const uint GL_TEXTURE_COORD_ARRAY = 0x8078;
        public const uint GL_EDGE_FLAG_ARRAY = 0x8079;
        public const uint GL_VERTEX_ARRAY_SIZE = 0x807A;
        public const uint GL_VERTEX_ARRAY_TYPE = 0x807B;
        public const uint GL_VERTEX_ARRAY_STRIDE = 0x807C;
        public const uint GL_NORMAL_ARRAY_TYPE = 0x807E;
        public const uint GL_NORMAL_ARRAY_STRIDE = 0x807F;
        public const uint GL_COLOR_ARRAY_SIZE = 0x8081;
        public const uint GL_COLOR_ARRAY_TYPE = 0x8082;
        public const uint GL_COLOR_ARRAY_STRIDE = 0x8083;
        public const uint GL_INDEX_ARRAY_TYPE = 0x8085;
        public const uint GL_INDEX_ARRAY_STRIDE = 0x8086;
        public const uint GL_TEXTURE_COORD_ARRAY_SIZE = 0x8088;
        public const uint GL_TEXTURE_COORD_ARRAY_TYPE = 0x8089;
        public const uint GL_TEXTURE_COORD_ARRAY_STRIDE = 0x808A;
        public const uint GL_EDGE_FLAG_ARRAY_STRIDE = 0x808C;
        public const uint GL_VERTEX_ARRAY_POINTER = 0x808E;
        public const uint GL_NORMAL_ARRAY_POINTER = 0x808F;
        public const uint GL_COLOR_ARRAY_POINTER = 0x8090;
        public const uint GL_INDEX_ARRAY_POINTER = 0x8091;
        public const uint GL_TEXTURE_COORD_ARRAY_POINTER = 0x8092;
        public const uint GL_EDGE_FLAG_ARRAY_POINTER = 0x8093;
        public const uint GL_V2F = 0x2A20;
        public const uint GL_V3F = 0x2A21;
        public const uint GL_C4UB_V2F = 0x2A22;
        public const uint GL_C4UB_V3F = 0x2A23;
        public const uint GL_C3F_V3F = 0x2A24;
        public const uint GL_N3F_V3F = 0x2A25;
        public const uint GL_C4F_N3F_V3F = 0x2A26;
        public const uint GL_T2F_V3F = 0x2A27;
        public const uint GL_T4F_V4F = 0x2A28;
        public const uint GL_T2F_C4UB_V3F = 0x2A29;
        public const uint GL_T2F_C3F_V3F = 0x2A2A;
        public const uint GL_T2F_N3F_V3F = 0x2A2B;
        public const uint GL_T2F_C4F_N3F_V3F = 0x2A2C;
        public const uint GL_T4F_C4F_N3F_V4F = 0x2A2D;

        /* Matrix Mode */

        public const uint GL_MATRIX_MODE = 0x0BA0;
        public const uint GL_MODELVIEW = 0x1700;
        public const uint GL_PROJECTION = 0x1701;
        public const uint GL_TEXTURE = 0x1702;

        /* Points */

        public const uint GL_POINT_SMOOTH = 0x0B10;
        public const uint GL_POINT_SIZE = 0x0B11;
        public const uint GL_POINT_SIZE_GRANULARITY = 0x0B13;
        public const uint GL_POINT_SIZE_RANGE = 0x0B12;

        /* Lines */

        public const uint GL_LINE_SMOOTH = 0x0B20;
        public const uint GL_LINE_STIPPLE = 0x0B24;
        public const uint GL_LINE_STIPPLE_PATTERN = 0x0B25;
        public const uint GL_LINE_STIPPLE_REPEAT = 0x0B26;
        public const uint GL_LINE_WIDTH = 0x0B21;
        public const uint GL_LINE_WIDTH_GRANULARITY = 0x0B23;
        public const uint GL_LINE_WIDTH_RANGE = 0x0B22;

        /* Polygons */

        public const uint GL_POINT = 0x1B00;
        public const uint GL_LINE = 0x1B01;
        public const uint GL_FILL = 0x1B02;
        public const uint GL_CW = 0x0900;
        public const uint GL_CCW = 0x0901;
        public const uint GL_FRONT = 0x0404;
        public const uint GL_BACK = 0x0405;
        public const uint GL_POLYGON_MODE = 0x0B40;
        public const uint GL_POLYGON_SMOOTH = 0x0B41;
        public const uint GL_POLYGON_STIPPLE = 0x0B42;
        public const uint GL_EDGE_FLAG = 0x0B43;
        public const uint GL_CULL_FACE = 0x0B44;
        public const uint GL_CULL_FACE_MODE = 0x0B45;
        public const uint GL_FRONT_FACE = 0x0B46;
        public const uint GL_POLYGON_OFFSET_FACTOR = 0x8038;
        public const uint GL_POLYGON_OFFSET_UNITS = 0x2A00;
        public const uint GL_POLYGON_OFFSET_POINT = 0x2A01;
        public const uint GL_POLYGON_OFFSET_LINE = 0x2A02;
        public const uint GL_POLYGON_OFFSET_FILL = 0x8037;

        /* Display Lists */

        public const uint GL_COMPILE = 0x1300;
        public const uint GL_COMPILE_AND_EXECUTE = 0x1301;
        public const uint GL_LIST_BASE = 0x0B32;
        public const uint GL_LIST_INDEX = 0x0B33;
        public const uint GL_LIST_MODE = 0x0B30;

        /* Depth buffer */

        public const uint GL_NEVER = 0x0200;
        public const uint GL_LESS = 0x0201;
        public const uint GL_EQUAL = 0x0202;
        public const uint GL_LEQUAL = 0x0203;
        public const uint GL_GREATER = 0x0204;
        public const uint GL_NOTEQUAL = 0x0205;
        public const uint GL_GEQUAL = 0x0206;
        public const uint GL_ALWAYS = 0x0207;
        public const uint GL_DEPTH_TEST = 0x0B71;
        public const uint GL_DEPTH_BITS = 0x0D56;
        public const uint GL_DEPTH_CLEAR_VALUE = 0x0B73;
        public const uint GL_DEPTH_FUNC = 0x0B74;
        public const uint GL_DEPTH_RANGE = 0x0B70;
        public const uint GL_DEPTH_WRITEMASK = 0x0B72;
        public const uint GL_DEPTH_COMPONENT = 0x1902;

        /* Lighting */

        public const uint GL_LIGHTING = 0x0B50;
        public const uint GL_LIGHT0 = 0x4000;
        public const uint GL_LIGHT1 = 0x4001;
        public const uint GL_LIGHT2 = 0x4002;
        public const uint GL_LIGHT3 = 0x4003;
        public const uint GL_LIGHT4 = 0x4004;
        public const uint GL_LIGHT5 = 0x4005;
        public const uint GL_LIGHT6 = 0x4006;
        public const uint GL_LIGHT7 = 0x4007;
        public const uint GL_SPOT_EXPONENT = 0x1205;
        public const uint GL_SPOT_CUTOFF = 0x1206;
        public const uint GL_CONSTANT_ATTENUATION = 0x1207;
        public const uint GL_LINEAR_ATTENUATION = 0x1208;
        public const uint GL_QUADRATIC_ATTENUATION = 0x1209;
        public const uint GL_AMBIENT = 0x1200;
        public const uint GL_DIFFUSE = 0x1201;
        public const uint GL_SPECULAR = 0x1202;
        public const uint GL_SHININESS = 0x1601;
        public const uint GL_EMISSION = 0x1600;
        public const uint GL_POSITION = 0x1203;
        public const uint GL_SPOT_DIRECTION = 0x1204;
        public const uint GL_AMBIENT_AND_DIFFUSE = 0x1602;
        public const uint GL_COLOR_INDEXES = 0x1603;
        public const uint GL_LIGHT_MODEL_TWO_SIDE = 0x0B52;
        public const uint GL_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51;
        public const uint GL_LIGHT_MODEL_AMBIENT = 0x0B53;
        public const uint GL_FRONT_AND_BACK = 0x0408;
        public const uint GL_SHADE_MODEL = 0x0B54;
        public const uint GL_FLAT = 0x1D00;
        public const uint GL_SMOOTH = 0x1D01;
        public const uint GL_COLOR_MATERIAL = 0x0B57;
        public const uint GL_COLOR_MATERIAL_FACE = 0x0B55;
        public const uint GL_COLOR_MATERIAL_PARAMETER = 0x0B56;
        public const uint GL_NORMALIZE = 0x0BA1;

        /* User clipping planes */

        public const uint GL_CLIP_PLANE0 = 0x3000;
        public const uint GL_CLIP_PLANE1 = 0x3001;
        public const uint GL_CLIP_PLANE2 = 0x3002;
        public const uint GL_CLIP_PLANE3 = 0x3003;
        public const uint GL_CLIP_PLANE4 = 0x3004;
        public const uint GL_CLIP_PLANE5 = 0x3005;

        /* Accumulation buffer */

        public const uint GL_ACCUM_RED_BITS = 0x0D58;
        public const uint GL_ACCUM_GREEN_BITS = 0x0D59;
        public const uint GL_ACCUM_BLUE_BITS = 0x0D5A;
        public const uint GL_ACCUM_ALPHA_BITS = 0x0D5B;
        public const uint GL_ACCUM_CLEAR_VALUE = 0x0B80;
        public const uint GL_ACCUM = 0x0100;
        public const uint GL_ADD = 0x0104;
        public const uint GL_LOAD = 0x0101;
        public const uint GL_MULT = 0x0103;
        public const uint GL_RETURN = 0x0102;

        /* Alpha testing */

        public const uint GL_ALPHA_TEST = 0x0BC0;
        public const uint GL_ALPHA_TEST_REF = 0x0BC2;
        public const uint GL_ALPHA_TEST_FUNC = 0x0BC1;

        /* Blending */

        public const uint GL_BLEND = 0x0BE2;
        public const uint GL_BLEND_SRC = 0x0BE1;
        public const uint GL_BLEND_DST = 0x0BE0;
        public const uint GL_ZERO = 0x0;
        public const uint GL_ONE = 0x1;
        public const uint GL_SRC_COLOR = 0x0300;
        public const uint GL_ONE_MINUS_SRC_COLOR = 0x0301;
        public const uint GL_SRC_ALPHA = 0x0302;
        public const uint GL_ONE_MINUS_SRC_ALPHA = 0x0303;
        public const uint GL_DST_ALPHA = 0x0304;
        public const uint GL_ONE_MINUS_DST_ALPHA = 0x0305;
        public const uint GL_DST_COLOR = 0x0306;
        public const uint GL_ONE_MINUS_DST_COLOR = 0x0307;
        public const uint GL_SRC_ALPHA_SATURATE = 0x0308;
        public const uint GL_CONSTANT_COLOR = 0x8001;
        public const uint GL_ONE_MINUS_CONSTANT_COLOR = 0x8002;
        public const uint GL_CONSTANT_ALPHA = 0x8003;
        public const uint GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004;

        /* Render Mode */

        public const uint GL_FEEDBACK = 0x1C01;
        public const uint GL_RENDER = 0x1C00;
        public const uint GL_SELECT = 0x1C02;

        /* Feedback */

        public const uint GL_2D = 0x0600;
        public const uint GL_3D = 0x0601;
        public const uint GL_3D_COLOR = 0x0602;
        public const uint GL_3D_COLOR_TEXTURE = 0x0603;
        public const uint GL_4D_COLOR_TEXTURE = 0x0604;
        public const uint GL_POINT_TOKEN = 0x0701;
        public const uint GL_LINE_TOKEN = 0x0702;
        public const uint GL_LINE_RESET_TOKEN = 0x0707;
        public const uint GL_POLYGON_TOKEN = 0x0703;
        public const uint GL_BITMAP_TOKEN = 0x0704;
        public const uint GL_DRAW_PIXEL_TOKEN = 0x0705;
        public const uint GL_COPY_PIXEL_TOKEN = 0x0706;
        public const uint GL_PASS_THROUGH_TOKEN = 0x0700;
        public const uint GL_FEEDBACK_BUFFER_POINTER = 0x0DF0;
        public const uint GL_FEEDBACK_BUFFER_SIZE = 0x0DF1;
        public const uint GL_FEEDBACK_BUFFER_TYPE = 0x0DF2;

        /* Selection */

        public const uint GL_SELECTION_BUFFER_POINTER = 0x0DF3;
        public const uint GL_SELECTION_BUFFER_SIZE = 0x0DF4;

        /* Fog */

        public const uint GL_FOG = 0x0B60;
        public const uint GL_FOG_MODE = 0x0B65;
        public const uint GL_FOG_DENSITY = 0x0B62;
        public const uint GL_FOG_COLOR = 0x0B66;
        public const uint GL_FOG_INDEX = 0x0B61;
        public const uint GL_FOG_START = 0x0B63;
        public const uint GL_FOG_END = 0x0B64;
        public const uint GL_LINEAR = 0x2601;
        public const uint GL_EXP = 0x0800;
        public const uint GL_EXP2 = 0x0801;

        /* Logic Ops */

        public const uint GL_LOGIC_OP = 0x0BF1;
        public const uint GL_INDEX_LOGIC_OP = 0x0BF1;
        public const uint GL_COLOR_LOGIC_OP = 0x0BF2;
        public const uint GL_LOGIC_OP_MODE = 0x0BF0;
        public const uint GL_CLEAR = 0x1500;
        public const uint GL_SET = 0x150F;
        public const uint GL_COPY = 0x1503;
        public const uint GL_COPY_INVERTED = 0x150C;
        public const uint GL_NOOP = 0x1505;
        public const uint GL_INVERT = 0x150A;
        public const uint GL_AND = 0x1501;
        public const uint GL_NAND = 0x150E;
        public const uint GL_OR = 0x1507;
        public const uint GL_NOR = 0x1508;
        public const uint GL_XOR = 0x1506;
        public const uint GL_EQUIV = 0x1509;
        public const uint GL_AND_REVERSE = 0x1502;
        public const uint GL_AND_INVERTED = 0x1504;
        public const uint GL_OR_REVERSE = 0x150B;
        public const uint GL_OR_INVERTED = 0x150D;

        /* Stencil */

        public const uint GL_STENCIL_TEST = 0x0B90;
        public const uint GL_STENCIL_WRITEMASK = 0x0B98;
        public const uint GL_STENCIL_BITS = 0x0D57;
        public const uint GL_STENCIL_FUNC = 0x0B92;
        public const uint GL_STENCIL_VALUE_MASK = 0x0B93;
        public const uint GL_STENCIL_REF = 0x0B97;
        public const uint GL_STENCIL_FAIL = 0x0B94;
        public const uint GL_STENCIL_PASS_DEPTH_PASS = 0x0B96;
        public const uint GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95;
        public const uint GL_STENCIL_CLEAR_VALUE = 0x0B91;
        public const uint GL_STENCIL_INDEX = 0x1901;
        public const uint GL_KEEP = 0x1E00;
        public const uint GL_REPLACE = 0x1E01;
        public const uint GL_INCR = 0x1E02;
        public const uint GL_DECR = 0x1E03;

        /* Buffers, Pixel Drawing/Reading */

        public const uint GL_NONE = 0x0;
        public const uint GL_LEFT = 0x0406;
        public const uint GL_RIGHT = 0x0407;

        /*GL_FRONT                                      0x0404 */


        /*GL_BACK                                       0x0405 */


        /*GL_FRONT_AND_BACK                             0x0408 */

        public const uint GL_FRONT_LEFT = 0x0400;
        public const uint GL_FRONT_RIGHT = 0x0401;
        public const uint GL_BACK_LEFT = 0x0402;
        public const uint GL_BACK_RIGHT = 0x0403;
        public const uint GL_AUX0 = 0x0409;
        public const uint GL_AUX1 = 0x040A;
        public const uint GL_AUX2 = 0x040B;
        public const uint GL_AUX3 = 0x040C;
        public const uint GL_COLOR_INDEX = 0x1900;
        public const uint GL_RED = 0x1903;
        public const uint GL_GREEN = 0x1904;
        public const uint GL_BLUE = 0x1905;
        public const uint GL_ALPHA = 0x1906;
        public const uint GL_LUMINANCE = 0x1909;
        public const uint GL_LUMINANCE_ALPHA = 0x190A;
        public const uint GL_ALPHA_BITS = 0x0D55;
        public const uint GL_RED_BITS = 0x0D52;
        public const uint GL_GREEN_BITS = 0x0D53;
        public const uint GL_BLUE_BITS = 0x0D54;
        public const uint GL_INDEX_BITS = 0x0D51;
        public const uint GL_SUBPIXEL_BITS = 0x0D50;
        public const uint GL_AUX_BUFFERS = 0x0C00;
        public const uint GL_READ_BUFFER = 0x0C02;
        public const uint GL_DRAW_BUFFER = 0x0C01;
        public const uint GL_DOUBLEBUFFER = 0x0C32;
        public const uint GL_STEREO = 0x0C33;
        public const uint GL_BITMAP = 0x1A00;
        public const uint GL_COLOR = 0x1800;
        public const uint GL_DEPTH = 0x1801;
        public const uint GL_STENCIL = 0x1802;
        public const uint GL_DITHER = 0x0BD0;
        public const uint GL_RGB = 0x1907;
        public const uint GL_RGBA = 0x1908;

        /* Implementation limits */

        public const uint GL_MAX_LIST_NESTING = 0x0B31;
        public const uint GL_MAX_ATTRIB_STACK_DEPTH = 0x0D35;
        public const uint GL_MAX_MODELVIEW_STACK_DEPTH = 0x0D36;
        public const uint GL_MAX_NAME_STACK_DEPTH = 0x0D37;
        public const uint GL_MAX_PROJECTION_STACK_DEPTH = 0x0D38;
        public const uint GL_MAX_TEXTURE_STACK_DEPTH = 0x0D39;
        public const uint GL_MAX_EVAL_ORDER = 0x0D30;
        public const uint GL_MAX_LIGHTS = 0x0D31;
        public const uint GL_MAX_CLIP_PLANES = 0x0D32;
        public const uint GL_MAX_TEXTURE_SIZE = 0x0D33;
        public const uint GL_MAX_PIXEL_MAP_TABLE = 0x0D34;
        public const uint GL_MAX_VIEWPORT_DIMS = 0x0D3A;
        public const uint GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B;

        /* Gets */

        public const uint GL_ATTRIB_STACK_DEPTH = 0x0BB0;
        public const uint GL_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1;
        public const uint GL_COLOR_CLEAR_VALUE = 0x0C22;
        public const uint GL_COLOR_WRITEMASK = 0x0C23;
        public const uint GL_CURRENT_INDEX = 0x0B01;
        public const uint GL_CURRENT_COLOR = 0x0B00;
        public const uint GL_CURRENT_NORMAL = 0x0B02;
        public const uint GL_CURRENT_RASTER_COLOR = 0x0B04;
        public const uint GL_CURRENT_RASTER_DISTANCE = 0x0B09;
        public const uint GL_CURRENT_RASTER_INDEX = 0x0B05;
        public const uint GL_CURRENT_RASTER_POSITION = 0x0B07;
        public const uint GL_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06;
        public const uint GL_CURRENT_RASTER_POSITION_VALID = 0x0B08;
        public const uint GL_CURRENT_TEXTURE_COORDS = 0x0B03;
        public const uint GL_INDEX_CLEAR_VALUE = 0x0C20;
        public const uint GL_INDEX_MODE = 0x0C30;
        public const uint GL_INDEX_WRITEMASK = 0x0C21;
        public const uint GL_MODELVIEW_MATRIX = 0x0BA6;
        public const uint GL_MODELVIEW_STACK_DEPTH = 0x0BA3;
        public const uint GL_NAME_STACK_DEPTH = 0x0D70;
        public const uint GL_PROJECTION_MATRIX = 0x0BA7;
        public const uint GL_PROJECTION_STACK_DEPTH = 0x0BA4;
        public const uint GL_RENDER_MODE = 0x0C40;
        public const uint GL_RGBA_MODE = 0x0C31;
        public const uint GL_TEXTURE_MATRIX = 0x0BA8;
        public const uint GL_TEXTURE_STACK_DEPTH = 0x0BA5;
        public const uint GL_VIEWPORT = 0x0BA2;

        /* Evaluators */

        public const uint GL_AUTO_NORMAL = 0x0D80;
        public const uint GL_MAP1_COLOR_4 = 0x0D90;
        public const uint GL_MAP1_GRID_DOMAIN = 0x0DD0;
        public const uint GL_MAP1_GRID_SEGMENTS = 0x0DD1;
        public const uint GL_MAP1_INDEX = 0x0D91;
        public const uint GL_MAP1_NORMAL = 0x0D92;
        public const uint GL_MAP1_TEXTURE_COORD_1 = 0x0D93;
        public const uint GL_MAP1_TEXTURE_COORD_2 = 0x0D94;
        public const uint GL_MAP1_TEXTURE_COORD_3 = 0x0D95;
        public const uint GL_MAP1_TEXTURE_COORD_4 = 0x0D96;
        public const uint GL_MAP1_VERTEX_3 = 0x0D97;
        public const uint GL_MAP1_VERTEX_4 = 0x0D98;
        public const uint GL_MAP2_COLOR_4 = 0x0DB0;
        public const uint GL_MAP2_GRID_DOMAIN = 0x0DD2;
        public const uint GL_MAP2_GRID_SEGMENTS = 0x0DD3;
        public const uint GL_MAP2_INDEX = 0x0DB1;
        public const uint GL_MAP2_NORMAL = 0x0DB2;
        public const uint GL_MAP2_TEXTURE_COORD_1 = 0x0DB3;
        public const uint GL_MAP2_TEXTURE_COORD_2 = 0x0DB4;
        public const uint GL_MAP2_TEXTURE_COORD_3 = 0x0DB5;
        public const uint GL_MAP2_TEXTURE_COORD_4 = 0x0DB6;
        public const uint GL_MAP2_VERTEX_3 = 0x0DB7;
        public const uint GL_MAP2_VERTEX_4 = 0x0DB8;
        public const uint GL_COEFF = 0x0A00;
        public const uint GL_DOMAIN = 0x0A02;
        public const uint GL_ORDER = 0x0A01;

        /* Hints */

        public const uint GL_FOG_HINT = 0x0C54;
        public const uint GL_LINE_SMOOTH_HINT = 0x0C52;
        public const uint GL_PERSPECTIVE_CORRECTION_HINT = 0x0C50;
        public const uint GL_POINT_SMOOTH_HINT = 0x0C51;
        public const uint GL_POLYGON_SMOOTH_HINT = 0x0C53;
        public const uint GL_DONT_CARE = 0x1100;
        public const uint GL_FASTEST = 0x1101;
        public const uint GL_NICEST = 0x1102;

        /* Scissor box */

        public const uint GL_SCISSOR_TEST = 0x0C11;
        public const uint GL_SCISSOR_BOX = 0x0C10;

        /* Pixel Mode / Transfer */

        public const uint GL_MAP_COLOR = 0x0D10;
        public const uint GL_MAP_STENCIL = 0x0D11;
        public const uint GL_INDEX_SHIFT = 0x0D12;
        public const uint GL_INDEX_OFFSET = 0x0D13;
        public const uint GL_RED_SCALE = 0x0D14;
        public const uint GL_RED_BIAS = 0x0D15;
        public const uint GL_GREEN_SCALE = 0x0D18;
        public const uint GL_GREEN_BIAS = 0x0D19;
        public const uint GL_BLUE_SCALE = 0x0D1A;
        public const uint GL_BLUE_BIAS = 0x0D1B;
        public const uint GL_ALPHA_SCALE = 0x0D1C;
        public const uint GL_ALPHA_BIAS = 0x0D1D;
        public const uint GL_DEPTH_SCALE = 0x0D1E;
        public const uint GL_DEPTH_BIAS = 0x0D1F;
        public const uint GL_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1;
        public const uint GL_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0;
        public const uint GL_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2;
        public const uint GL_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3;
        public const uint GL_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4;
        public const uint GL_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5;
        public const uint GL_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6;
        public const uint GL_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7;
        public const uint GL_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8;
        public const uint GL_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9;
        public const uint GL_PIXEL_MAP_S_TO_S = 0x0C71;
        public const uint GL_PIXEL_MAP_I_TO_I = 0x0C70;
        public const uint GL_PIXEL_MAP_I_TO_R = 0x0C72;
        public const uint GL_PIXEL_MAP_I_TO_G = 0x0C73;
        public const uint GL_PIXEL_MAP_I_TO_B = 0x0C74;
        public const uint GL_PIXEL_MAP_I_TO_A = 0x0C75;
        public const uint GL_PIXEL_MAP_R_TO_R = 0x0C76;
        public const uint GL_PIXEL_MAP_G_TO_G = 0x0C77;
        public const uint GL_PIXEL_MAP_B_TO_B = 0x0C78;
        public const uint GL_PIXEL_MAP_A_TO_A = 0x0C79;
        public const uint GL_PACK_ALIGNMENT = 0x0D05;
        public const uint GL_PACK_LSB_FIRST = 0x0D01;
        public const uint GL_PACK_ROW_LENGTH = 0x0D02;
        public const uint GL_PACK_SKIP_PIXELS = 0x0D04;
        public const uint GL_PACK_SKIP_ROWS = 0x0D03;
        public const uint GL_PACK_SWAP_BYTES = 0x0D00;
        public const uint GL_UNPACK_ALIGNMENT = 0x0CF5;
        public const uint GL_UNPACK_LSB_FIRST = 0x0CF1;
        public const uint GL_UNPACK_ROW_LENGTH = 0x0CF2;
        public const uint GL_UNPACK_SKIP_PIXELS = 0x0CF4;
        public const uint GL_UNPACK_SKIP_ROWS = 0x0CF3;
        public const uint GL_UNPACK_SWAP_BYTES = 0x0CF0;
        public const uint GL_ZOOM_X = 0x0D16;
        public const uint GL_ZOOM_Y = 0x0D17;

        /* Texture mapping */

        public const uint GL_TEXTURE_ENV = 0x2300;
        public const uint GL_TEXTURE_ENV_MODE = 0x2200;
        public const uint GL_TEXTURE_1D = 0x0DE0;
        public const uint GL_TEXTURE_2D = 0x0DE1;
        public const uint GL_TEXTURE_WRAP_S = 0x2802;
        public const uint GL_TEXTURE_WRAP_T = 0x2803;
        public const uint GL_TEXTURE_MAG_FILTER = 0x2800;
        public const uint GL_TEXTURE_MIN_FILTER = 0x2801;
        public const uint GL_TEXTURE_ENV_COLOR = 0x2201;
        public const uint GL_TEXTURE_GEN_S = 0x0C60;
        public const uint GL_TEXTURE_GEN_T = 0x0C61;
        public const uint GL_TEXTURE_GEN_MODE = 0x2500;
        public const uint GL_TEXTURE_BORDER_COLOR = 0x1004;
        public const uint GL_TEXTURE_WIDTH = 0x1000;
        public const uint GL_TEXTURE_HEIGHT = 0x1001;
        public const uint GL_TEXTURE_BORDER = 0x1005;
        public const uint GL_TEXTURE_COMPONENTS = 0x1003;
        public const uint GL_TEXTURE_RED_SIZE = 0x805C;
        public const uint GL_TEXTURE_GREEN_SIZE = 0x805D;
        public const uint GL_TEXTURE_BLUE_SIZE = 0x805E;
        public const uint GL_TEXTURE_ALPHA_SIZE = 0x805F;
        public const uint GL_TEXTURE_LUMINANCE_SIZE = 0x8060;
        public const uint GL_TEXTURE_INTENSITY_SIZE = 0x8061;
        public const uint GL_NEAREST_MIPMAP_NEAREST = 0x2700;
        public const uint GL_NEAREST_MIPMAP_LINEAR = 0x2702;
        public const uint GL_LINEAR_MIPMAP_NEAREST = 0x2701;
        public const uint GL_LINEAR_MIPMAP_LINEAR = 0x2703;
        public const uint GL_OBJECT_LINEAR = 0x2401;
        public const uint GL_OBJECT_PLANE = 0x2501;
        public const uint GL_EYE_LINEAR = 0x2400;
        public const uint GL_EYE_PLANE = 0x2502;
        public const uint GL_SPHERE_MAP = 0x2402;
        public const uint GL_DECAL = 0x2101;
        public const uint GL_MODULATE = 0x2100;
        public const uint GL_NEAREST = 0x2600;
        public const uint GL_REPEAT = 0x2901;
        public const uint GL_CLAMP = 0x2900;
        public const uint GL_S = 0x2000;
        public const uint GL_T = 0x2001;
        public const uint GL_R = 0x2002;
        public const uint GL_Q = 0x2003;
        public const uint GL_TEXTURE_GEN_R = 0x0C62;
        public const uint GL_TEXTURE_GEN_Q = 0x0C63;

        /* Utility */

        public const uint GL_VENDOR = 0x1F00;
        public const uint GL_RENDERER = 0x1F01;
        public const uint GL_VERSION = 0x1F02;
        public const uint GL_EXTENSIONS = 0x1F03;

        /* Errors */

        public const uint GL_NO_ERROR = 0x0;
        public const uint GL_INVALID_VALUE = 0x0501;
        public const uint GL_INVALID_ENUM = 0x0500;
        public const uint GL_INVALID_OPERATION = 0x0502;
        public const uint GL_STACK_OVERFLOW = 0x0503;
        public const uint GL_STACK_UNDERFLOW = 0x0504;
        public const uint GL_OUT_OF_MEMORY = 0x0505;

        /* glPush/PopAttrib bits */

        public const uint GL_CURRENT_BIT = 0x00000001;
        public const uint GL_POINT_BIT = 0x00000002;
        public const uint GL_LINE_BIT = 0x00000004;
        public const uint GL_POLYGON_BIT = 0x00000008;
        public const uint GL_POLYGON_STIPPLE_BIT = 0x00000010;
        public const uint GL_PIXEL_MODE_BIT = 0x00000020;
        public const uint GL_LIGHTING_BIT = 0x00000040;
        public const uint GL_FOG_BIT = 0x00000080;
        public const uint GL_DEPTH_BUFFER_BIT = 0x00000100;
        public const uint GL_ACCUM_BUFFER_BIT = 0x00000200;
        public const uint GL_STENCIL_BUFFER_BIT = 0x00000400;
        public const uint GL_VIEWPORT_BIT = 0x00000800;
        public const uint GL_TRANSFORM_BIT = 0x00001000;
        public const uint GL_ENABLE_BIT = 0x00002000;
        public const uint GL_COLOR_BUFFER_BIT = 0x00004000;
        public const uint GL_HINT_BIT = 0x00008000;
        public const uint GL_EVAL_BIT = 0x00010000;
        public const uint GL_LIST_BIT = 0x00020000;
        public const uint GL_TEXTURE_BIT = 0x00040000;
        public const uint GL_SCISSOR_BIT = 0x00080000;
        public const uint GL_ALL_ATTRIB_BITS = 0x000FFFFF;

        /* OpenGL 1.1 */

        public const uint GL_PROXY_TEXTURE_1D = 0x8063;
        public const uint GL_PROXY_TEXTURE_2D = 0x8064;
        public const uint GL_TEXTURE_PRIORITY = 0x8066;
        public const uint GL_TEXTURE_RESIDENT = 0x8067;
        public const uint GL_TEXTURE_BINDING_1D = 0x8068;
        public const uint GL_TEXTURE_BINDING_2D = 0x8069;
        public const uint GL_TEXTURE_INTERNAL_FORMAT = 0x1003;
        public const uint GL_ALPHA4 = 0x803B;
        public const uint GL_ALPHA8 = 0x803C;
        public const uint GL_ALPHA12 = 0x803D;
        public const uint GL_ALPHA16 = 0x803E;
        public const uint GL_LUMINANCE4 = 0x803F;
        public const uint GL_LUMINANCE8 = 0x8040;
        public const uint GL_LUMINANCE12 = 0x8041;
        public const uint GL_LUMINANCE16 = 0x8042;
        public const uint GL_LUMINANCE4_ALPHA4 = 0x8043;
        public const uint GL_LUMINANCE6_ALPHA2 = 0x8044;
        public const uint GL_LUMINANCE8_ALPHA8 = 0x8045;
        public const uint GL_LUMINANCE12_ALPHA4 = 0x8046;
        public const uint GL_LUMINANCE12_ALPHA12 = 0x8047;
        public const uint GL_LUMINANCE16_ALPHA16 = 0x8048;
        public const uint GL_INTENSITY = 0x8049;
        public const uint GL_INTENSITY4 = 0x804A;
        public const uint GL_INTENSITY8 = 0x804B;
        public const uint GL_INTENSITY12 = 0x804C;
        public const uint GL_INTENSITY16 = 0x804D;
        public const uint GL_R3_G3_B2 = 0x2A10;
        public const uint GL_RGB4 = 0x804F;
        public const uint GL_RGB5 = 0x8050;
        public const uint GL_RGB8 = 0x8051;
        public const uint GL_RGB10 = 0x8052;
        public const uint GL_RGB12 = 0x8053;
        public const uint GL_RGB16 = 0x8054;
        public const uint GL_RGBA2 = 0x8055;
        public const uint GL_RGBA4 = 0x8056;
        public const uint GL_RGB5_A1 = 0x8057;
        public const uint GL_RGBA8 = 0x8058;
        public const uint GL_RGB10_A2 = 0x8059;
        public const uint GL_RGBA12 = 0x805A;
        public const uint GL_RGBA16 = 0x805B;
        public const uint GL_CLIENT_PIXEL_STORE_BIT = 0x00000001;
        public const uint GL_CLIENT_VERTEX_ARRAY_BIT = 0x00000002;
        public const uint GL_ALL_CLIENT_ATTRIB_BITS = 0xFFFFFFFF;
        public const uint GL_CLIENT_ALL_ATTRIB_BITS = 0xFFFFFFFF;

        /* Under Windows, we do not define OpenGL 1.2 & 1.3 functionality, since


        /* OpenGL 1.2 */

        public const uint GL_RESCALE_NORMAL = 0x803A;
        public const uint GL_CLAMP_TO_EDGE = 0x812F;
        public const uint GL_MAX_ELEMENTS_VERTICES = 0x80E8;
        public const uint GL_MAX_ELEMENTS_INDICES = 0x80E9;
        public const uint GL_BGR = 0x80E0;
        public const uint GL_BGRA = 0x80E1;
        public const uint GL_UNSIGNED_BYTE_3_3_2 = 0x8032;
        public const uint GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362;
        public const uint GL_UNSIGNED_SHORT_5_6_5 = 0x8363;
        public const uint GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364;
        public const uint GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033;
        public const uint GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365;
        public const uint GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034;
        public const uint GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366;
        public const uint GL_UNSIGNED_INT_8_8_8_8 = 0x8035;
        public const uint GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367;
        public const uint GL_UNSIGNED_INT_10_10_10_2 = 0x8036;
        public const uint GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368;
        public const uint GL_LIGHT_MODEL_COLOR_CONTROL = 0x81F8;
        public const uint GL_SINGLE_COLOR = 0x81F9;
        public const uint GL_SEPARATE_SPECULAR_COLOR = 0x81FA;
        public const uint GL_TEXTURE_MIN_LOD = 0x813A;
        public const uint GL_TEXTURE_MAX_LOD = 0x813B;
        public const uint GL_TEXTURE_BASE_LEVEL = 0x813C;
        public const uint GL_TEXTURE_MAX_LEVEL = 0x813D;
        public const uint GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12;
        public const uint GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13;
        public const uint GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22;
        public const uint GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23;
        public const uint GL_ALIASED_POINT_SIZE_RANGE = 0x846D;
        public const uint GL_ALIASED_LINE_WIDTH_RANGE = 0x846E;
        public const uint GL_PACK_SKIP_IMAGES = 0x806B;
        public const uint GL_PACK_IMAGE_HEIGHT = 0x806C;
        public const uint GL_UNPACK_SKIP_IMAGES = 0x806D;
        public const uint GL_UNPACK_IMAGE_HEIGHT = 0x806E;
        public const uint GL_TEXTURE_3D = 0x806F;
        public const uint GL_PROXY_TEXTURE_3D = 0x8070;
        public const uint GL_TEXTURE_DEPTH = 0x8071;
        public const uint GL_TEXTURE_WRAP_R = 0x8072;
        public const uint GL_MAX_3D_TEXTURE_SIZE = 0x8073;
        public const uint GL_TEXTURE_BINDING_3D = 0x806A;

        /* OpenGL 1.2 imaging subset */


        /* GL_EXT_color_table */

        public const uint GL_COLOR_TABLE = 0x80D0;
        public const uint GL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1;
        public const uint GL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2;
        public const uint GL_PROXY_COLOR_TABLE = 0x80D3;
        public const uint GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4;
        public const uint GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5;
        public const uint GL_COLOR_TABLE_SCALE = 0x80D6;
        public const uint GL_COLOR_TABLE_BIAS = 0x80D7;
        public const uint GL_COLOR_TABLE_FORMAT = 0x80D8;
        public const uint GL_COLOR_TABLE_WIDTH = 0x80D9;
        public const uint GL_COLOR_TABLE_RED_SIZE = 0x80DA;
        public const uint GL_COLOR_TABLE_GREEN_SIZE = 0x80DB;
        public const uint GL_COLOR_TABLE_BLUE_SIZE = 0x80DC;
        public const uint GL_COLOR_TABLE_ALPHA_SIZE = 0x80DD;
        public const uint GL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE;
        public const uint GL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF;

        /* GL_EXT_convolution and GL_HP_convolution_border_modes */

        public const uint GL_CONVOLUTION_1D = 0x8010;
        public const uint GL_CONVOLUTION_2D = 0x8011;
        public const uint GL_SEPARABLE_2D = 0x8012;
        public const uint GL_CONVOLUTION_BORDER_MODE = 0x8013;
        public const uint GL_CONVOLUTION_FILTER_SCALE = 0x8014;
        public const uint GL_CONVOLUTION_FILTER_BIAS = 0x8015;
        public const uint GL_REDUCE = 0x8016;
        public const uint GL_CONVOLUTION_FORMAT = 0x8017;
        public const uint GL_CONVOLUTION_WIDTH = 0x8018;
        public const uint GL_CONVOLUTION_HEIGHT = 0x8019;
        public const uint GL_MAX_CONVOLUTION_WIDTH = 0x801A;
        public const uint GL_MAX_CONVOLUTION_HEIGHT = 0x801B;
        public const uint GL_POST_CONVOLUTION_RED_SCALE = 0x801C;
        public const uint GL_POST_CONVOLUTION_GREEN_SCALE = 0x801D;
        public const uint GL_POST_CONVOLUTION_BLUE_SCALE = 0x801E;
        public const uint GL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F;
        public const uint GL_POST_CONVOLUTION_RED_BIAS = 0x8020;
        public const uint GL_POST_CONVOLUTION_GREEN_BIAS = 0x8021;
        public const uint GL_POST_CONVOLUTION_BLUE_BIAS = 0x8022;
        public const uint GL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023;
        public const uint GL_CONSTANT_BORDER = 0x8151;
        public const uint GL_REPLICATE_BORDER = 0x8153;
        public const uint GL_CONVOLUTION_BORDER_COLOR = 0x8154;

        /* GL_SGI_color_matrix */

        public const uint GL_COLOR_MATRIX = 0x80B1;
        public const uint GL_COLOR_MATRIX_STACK_DEPTH = 0x80B2;
        public const uint GL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3;
        public const uint GL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4;
        public const uint GL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5;
        public const uint GL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6;
        public const uint GL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7;
        public const uint GL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8;
        public const uint GL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9;
        public const uint GL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA;
        public const uint GL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB;

        /* GL_EXT_histogram */

        public const uint GL_HISTOGRAM = 0x8024;
        public const uint GL_PROXY_HISTOGRAM = 0x8025;
        public const uint GL_HISTOGRAM_WIDTH = 0x8026;
        public const uint GL_HISTOGRAM_FORMAT = 0x8027;
        public const uint GL_HISTOGRAM_RED_SIZE = 0x8028;
        public const uint GL_HISTOGRAM_GREEN_SIZE = 0x8029;
        public const uint GL_HISTOGRAM_BLUE_SIZE = 0x802A;
        public const uint GL_HISTOGRAM_ALPHA_SIZE = 0x802B;
        public const uint GL_HISTOGRAM_LUMINANCE_SIZE = 0x802C;
        public const uint GL_HISTOGRAM_SINK = 0x802D;
        public const uint GL_MINMAX = 0x802E;
        public const uint GL_MINMAX_FORMAT = 0x802F;
        public const uint GL_MINMAX_SINK = 0x8030;
        public const uint GL_TABLE_TOO_LARGE = 0x8031;

        /* GL_EXT_blend_color, GL_EXT_blend_minmax */

        public const uint GL_BLEND_EQUATION = 0x8009;
        public const uint GL_MIN = 0x8007;
        public const uint GL_MAX = 0x8008;
        public const uint GL_FUNC_ADD = 0x8006;
        public const uint GL_FUNC_SUBTRACT = 0x800A;
        public const uint GL_FUNC_REVERSE_SUBTRACT = 0x800B;
        public const uint GL_BLEND_COLOR = 0x8005;

        /* OpenGL 1.3 */


        /* multitexture */

        public const uint GL_TEXTURE0 = 0x84C0;
        public const uint GL_TEXTURE1 = 0x84C1;
        public const uint GL_TEXTURE2 = 0x84C2;
        public const uint GL_TEXTURE3 = 0x84C3;
        public const uint GL_TEXTURE4 = 0x84C4;
        public const uint GL_TEXTURE5 = 0x84C5;
        public const uint GL_TEXTURE6 = 0x84C6;
        public const uint GL_TEXTURE7 = 0x84C7;
        public const uint GL_TEXTURE8 = 0x84C8;
        public const uint GL_TEXTURE9 = 0x84C9;
        public const uint GL_TEXTURE10 = 0x84CA;
        public const uint GL_TEXTURE11 = 0x84CB;
        public const uint GL_TEXTURE12 = 0x84CC;
        public const uint GL_TEXTURE13 = 0x84CD;
        public const uint GL_TEXTURE14 = 0x84CE;
        public const uint GL_TEXTURE15 = 0x84CF;
        public const uint GL_TEXTURE16 = 0x84D0;
        public const uint GL_TEXTURE17 = 0x84D1;
        public const uint GL_TEXTURE18 = 0x84D2;
        public const uint GL_TEXTURE19 = 0x84D3;
        public const uint GL_TEXTURE20 = 0x84D4;
        public const uint GL_TEXTURE21 = 0x84D5;
        public const uint GL_TEXTURE22 = 0x84D6;
        public const uint GL_TEXTURE23 = 0x84D7;
        public const uint GL_TEXTURE24 = 0x84D8;
        public const uint GL_TEXTURE25 = 0x84D9;
        public const uint GL_TEXTURE26 = 0x84DA;
        public const uint GL_TEXTURE27 = 0x84DB;
        public const uint GL_TEXTURE28 = 0x84DC;
        public const uint GL_TEXTURE29 = 0x84DD;
        public const uint GL_TEXTURE30 = 0x84DE;
        public const uint GL_TEXTURE31 = 0x84DF;
        public const uint GL_ACTIVE_TEXTURE = 0x84E0;
        public const uint GL_CLIENT_ACTIVE_TEXTURE = 0x84E1;
        public const uint GL_MAX_TEXTURE_UNITS = 0x84E2;

        /* texture_cube_map */

        public const uint GL_NORMAL_MAP = 0x8511;
        public const uint GL_REFLECTION_MAP = 0x8512;
        public const uint GL_TEXTURE_CUBE_MAP = 0x8513;
        public const uint GL_TEXTURE_BINDING_CUBE_MAP = 0x8514;
        public const uint GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515;
        public const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516;
        public const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517;
        public const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518;
        public const uint GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519;
        public const uint GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A;
        public const uint GL_PROXY_TEXTURE_CUBE_MAP = 0x851B;
        public const uint GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C;

        /* texture_compression */

        public const uint GL_COMPRESSED_ALPHA = 0x84E9;
        public const uint GL_COMPRESSED_LUMINANCE = 0x84EA;
        public const uint GL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB;
        public const uint GL_COMPRESSED_INTENSITY = 0x84EC;
        public const uint GL_COMPRESSED_RGB = 0x84ED;
        public const uint GL_COMPRESSED_RGBA = 0x84EE;
        public const uint GL_TEXTURE_COMPRESSION_HINT = 0x84EF;
        public const uint GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0;
        public const uint GL_TEXTURE_COMPRESSED = 0x86A1;
        public const uint GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2;
        public const uint GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3;

        /* multisample */

        public const uint GL_MULTISAMPLE = 0x809D;
        public const uint GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E;
        public const uint GL_SAMPLE_ALPHA_TO_ONE = 0x809F;
        public const uint GL_SAMPLE_COVERAGE = 0x80A0;
        public const uint GL_SAMPLE_BUFFERS = 0x80A8;
        public const uint GL_SAMPLES = 0x80A9;
        public const uint GL_SAMPLE_COVERAGE_VALUE = 0x80AA;
        public const uint GL_SAMPLE_COVERAGE_INVERT = 0x80AB;
        public const uint GL_MULTISAMPLE_BIT = 0x20000000;

        /* transpose_matrix */

        public const uint GL_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3;
        public const uint GL_TRANSPOSE_PROJECTION_MATRIX = 0x84E4;
        public const uint GL_TRANSPOSE_TEXTURE_MATRIX = 0x84E5;
        public const uint GL_TRANSPOSE_COLOR_MATRIX = 0x84E6;

        /* texture_env_combine */

        public const uint GL_COMBINE = 0x8570;
        public const uint GL_COMBINE_RGB = 0x8571;
        public const uint GL_COMBINE_ALPHA = 0x8572;
        public const uint GL_SOURCE0_RGB = 0x8580;
        public const uint GL_SOURCE1_RGB = 0x8581;
        public const uint GL_SOURCE2_RGB = 0x8582;
        public const uint GL_SOURCE0_ALPHA = 0x8588;
        public const uint GL_SOURCE1_ALPHA = 0x8589;
        public const uint GL_SOURCE2_ALPHA = 0x858A;
        public const uint GL_OPERAND0_RGB = 0x8590;
        public const uint GL_OPERAND1_RGB = 0x8591;
        public const uint GL_OPERAND2_RGB = 0x8592;
        public const uint GL_OPERAND0_ALPHA = 0x8598;
        public const uint GL_OPERAND1_ALPHA = 0x8599;
        public const uint GL_OPERAND2_ALPHA = 0x859A;
        public const uint GL_RGB_SCALE = 0x8573;
        public const uint GL_ADD_SIGNED = 0x8574;
        public const uint GL_INTERPOLATE = 0x8575;
        public const uint GL_SUBTRACT = 0x84E7;
        public const uint GL_CONSTANT = 0x8576;
        public const uint GL_PRIMARY_COLOR = 0x8577;
        public const uint GL_PREVIOUS = 0x8578;

        /* texture_env_dot3 */

        public const uint GL_DOT3_RGB = 0x86AE;
        public const uint GL_DOT3_RGBA = 0x86AF;

        /* texture_border_clamp */

        public const uint GL_CLAMP_TO_BORDER = 0x812D;

        #endregion

        #region Unknown constants

        public const uint GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE;

        #endregion

        #region Function prototypes

        #region Miscellaneous
        //GLAPI void APIENTRY glClearIndex( GLfloat c );

        [DllImport("opengl32")]
        public static extern void glClearColor(float red, float green, float blue, float alpha);

        //GLAPI void APIENTRY glClear( GLbitfield mask );
        //GLAPI void APIENTRY glIndexMask( GLuint mask );
        //GLAPI void APIENTRY glColorMask( GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha );

        [DllImport("opengl32")]
        public static extern void glAlphaFunc(uint func, float _ref);

        [DllImport("opengl32")]
        public static extern void glBlendFunc(uint sfactor, uint dfactor);

        //GLAPI void APIENTRY glLogicOp( GLenum opcode );
        //GLAPI void APIENTRY glCullFace( GLenum mode );

        [DllImport("opengl32")]
        public static extern void glFrontFace(uint mode);

        [DllImport("opengl32")]
        public static extern void glPointSize(float size);

        //GLAPI void APIENTRY glLineWidth( GLfloat width );
        //GLAPI void APIENTRY glLineStipple( GLint factor, GLushort pattern );

        [DllImport("opengl32")]
        public static extern void glPolygonMode(uint face, uint mode);

        //GLAPI void APIENTRY glPolygonOffset( GLfloat factor, GLfloat units );
        //GLAPI void APIENTRY glPolygonStipple( const GLubyte *mask );
        //GLAPI void APIENTRY glGetPolygonStipple( GLubyte *mask );
        //GLAPI void APIENTRY glEdgeFlag( GLboolean flag );
        //GLAPI void APIENTRY glEdgeFlagv( const GLboolean *flag );

        [DllImport("opengl32")]
        public static extern void glScissor(int x, int y, int width, int height);

        //GLAPI void APIENTRY glClipPlane( GLenum plane, const GLdouble *equation );
        //GLAPI void APIENTRY glGetClipPlane( GLenum plane, GLdouble *equation );

        [DllImport("opengl32")]
        public static extern void glDrawBuffer(uint mode);

        [DllImport("opengl32")]
        public static extern void glReadBuffer(uint mode);

        [DllImport("opengl32")]
        public static extern void glEnable(uint cap);

        [DllImport("opengl32")]
        public static extern void glDisable(uint cap);

        //GLAPI GLboolean APIENTRY glIsEnabled( GLenum cap );
        //GLAPI void APIENTRY glEnableClientState( GLenum cap );  /* 1.1 */
        //GLAPI void APIENTRY glDisableClientState( GLenum cap );  /* 1.1 */
        //GLAPI void APIENTRY glGetBooleanv( GLenum pname, GLboolean *params );
        //GLAPI void APIENTRY glGetDoublev( GLenum pname, GLdouble *params );
        //GLAPI void APIENTRY glGetFloatv( GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetIntegerv( GLenum pname, GLint *params );

        [DllImport("opengl32")]
        public static extern void glPushAttrib(uint mask);
        
        [DllImport("opengl32")]
        public static extern void glPopAttrib();

        //GLAPI void APIENTRY glPushClientAttrib( GLbitfield mask );  /* 1.1 */
        //GLAPI void APIENTRY glPopClientAttrib( void );  /* 1.1 */
        //GLAPI GLint APIENTRY glRenderMode( GLenum mode );
        
        [DllImport("opengl32")]
        public static extern uint glGetError();

        [DllImport("opengl32")]
        public static extern StringBuilder glGetString(uint name);

        //GLAPI void APIENTRY glFinish( void );
        //GLAPI void APIENTRY glFlush( void );

        [DllImport("opengl32")]
        public static extern void glHint(uint target, uint mode);

        #endregion

        #region Depth Buffer

        //GLAPI void APIENTRY glClearDepth( GLclampd depth );
        //GLAPI void APIENTRY glDepthFunc( GLenum func );
        //GLAPI void APIENTRY glDepthMask( GLboolean flag );
        //GLAPI void APIENTRY glDepthRange( GLclampd near_val, GLclampd far_val );

        #endregion

        ///* Accumulation Buffer */
        //GLAPI void APIENTRY glClearAccum( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha );
        //GLAPI void APIENTRY glAccum( GLenum op, GLfloat value );

        ///* Transformation */
        //GLAPI void APIENTRY glMatrixMode( GLenum mode );

        [DllImport("opengl32")]
        public static extern void glOrtho(double left, double right, double bottom, double top, double near_val, double far_val);

        //GLAPI void APIENTRY glFrustum( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val );

        [DllImport("opengl32")]
        public static extern void glViewport(int x, int y, int width, int height);

        //GLAPI void APIENTRY glPushMatrix( void );
        //GLAPI void APIENTRY glPopMatrix( void );
        //GLAPI void APIENTRY glLoadIdentity( void );
        //GLAPI void APIENTRY glLoadMatrixd( const GLdouble *m );
        //GLAPI void APIENTRY glLoadMatrixf( const GLfloat *m );
        //GLAPI void APIENTRY glMultMatrixd( const GLdouble *m );
        //GLAPI void APIENTRY glMultMatrixf( const GLfloat *m );
        //GLAPI void APIENTRY glRotated( GLdouble angle, GLdouble x, GLdouble y, GLdouble z );
        //GLAPI void APIENTRY glRotatef( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );
        //GLAPI void APIENTRY glScaled( GLdouble x, GLdouble y, GLdouble z );

        [DllImport("opengl32")]
        public static extern void glScalef(float x, float y, float z);

        //GLAPI void APIENTRY glTranslated( GLdouble x, GLdouble y, GLdouble z );
        //GLAPI void APIENTRY glTranslatef( GLfloat x, GLfloat y, GLfloat z );

        ///* Display Lists */
        //GLAPI GLboolean APIENTRY glIsList( GLuint list );
        //GLAPI void APIENTRY glDeleteLists( GLuint list, GLsizei range );
        //GLAPI GLuint APIENTRY glGenLists( GLsizei range );
        //GLAPI void APIENTRY glNewList( GLuint list, GLenum mode );
        //GLAPI void APIENTRY glEndList( void );
        //GLAPI void APIENTRY glCallList( GLuint list );
        //GLAPI void APIENTRY glCallLists( GLsizei n, GLenum type, const GLvoid *lists );
        //GLAPI void APIENTRY glListBase( GLuint base );

        #region Drawing Functions

        //GLAPI void APIENTRY glBegin( GLenum mode );
        //GLAPI void APIENTRY glEnd( void );

        [DllImport("opengl32")]
        public static extern void glVertex2d(double x, double y);

        [DllImport("opengl32")]
        public static extern void glVertex2f(float x, float y);

        [DllImport("opengl32")]
        public static extern void glVertex2i(int x, int y);

        //GLAPI void APIENTRY glVertex2s( GLshort x, GLshort y );
        //GLAPI void APIENTRY glVertex3d( GLdouble x, GLdouble y, GLdouble z );

        [DllImport("opengl32")]
        public static extern void glVertex3f(float x, float y, float z);

        //GLAPI void APIENTRY glVertex3i( GLint x, GLint y, GLint z );
        //GLAPI void APIENTRY glVertex3s( GLshort x, GLshort y, GLshort z );
        //GLAPI void APIENTRY glVertex4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
        //GLAPI void APIENTRY glVertex4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
        //GLAPI void APIENTRY glVertex4i( GLint x, GLint y, GLint z, GLint w );
        //GLAPI void APIENTRY glVertex4s( GLshort x, GLshort y, GLshort z, GLshort w );
        //GLAPI void APIENTRY glVertex2dv( const GLdouble *v );
        //GLAPI void APIENTRY glVertex2fv( const GLfloat *v );
        //GLAPI void APIENTRY glVertex2iv( const GLint *v );
        //GLAPI void APIENTRY glVertex2sv( const GLshort *v );
        //GLAPI void APIENTRY glVertex3dv( const GLdouble *v );       
        //GLAPI void APIENTRY glVertex3fv( const GLfloat *v );
        //GLAPI void APIENTRY glVertex3iv( const GLint *v );
        //GLAPI void APIENTRY glVertex3sv( const GLshort *v );
        //GLAPI void APIENTRY glVertex4dv( const GLdouble *v );
        //GLAPI void APIENTRY glVertex4fv( const GLfloat *v );
        //GLAPI void APIENTRY glVertex4iv( const GLint *v );
        //GLAPI void APIENTRY glVertex4sv( const GLshort *v );
        //GLAPI void APIENTRY glNormal3b( GLbyte nx, GLbyte ny, GLbyte nz );
        //GLAPI void APIENTRY glNormal3d( GLdouble nx, GLdouble ny, GLdouble nz );
        //GLAPI void APIENTRY glNormal3f( GLfloat nx, GLfloat ny, GLfloat nz );
        //GLAPI void APIENTRY glNormal3i( GLint nx, GLint ny, GLint nz );
        //GLAPI void APIENTRY glNormal3s( GLshort nx, GLshort ny, GLshort nz );
        //GLAPI void APIENTRY glNormal3bv( const GLbyte *v );
        //GLAPI void APIENTRY glNormal3dv( const GLdouble *v );
        //GLAPI void APIENTRY glNormal3fv( const GLfloat *v );
        //GLAPI void APIENTRY glNormal3iv( const GLint *v );
        //GLAPI void APIENTRY glNormal3sv( const GLshort *v );
        //GLAPI void APIENTRY glIndexd( GLdouble c );
        //GLAPI void APIENTRY glIndexf( GLfloat c );
        //GLAPI void APIENTRY glIndexi( GLint c );
        //GLAPI void APIENTRY glIndexs( GLshort c );
        //GLAPI void APIENTRY glIndexub( GLubyte c );  /* 1.1 */
        //GLAPI void APIENTRY glIndexdv( const GLdouble *c );
        //GLAPI void APIENTRY glIndexfv( const GLfloat *c );
        //GLAPI void APIENTRY glIndexiv( const GLint *c );
        //GLAPI void APIENTRY glIndexsv( const GLshort *c );
        //GLAPI void APIENTRY glIndexubv( const GLubyte *c );  /* 1.1 */
        //GLAPI void APIENTRY glColor3b( GLbyte red, GLbyte green, GLbyte blue );
        //GLAPI void APIENTRY glColor3d( GLdouble red, GLdouble green, GLdouble blue );
        //GLAPI void APIENTRY glColor3f( GLfloat red, GLfloat green, GLfloat blue );
        //GLAPI void APIENTRY glColor3i( GLint red, GLint green, GLint blue );
        //GLAPI void APIENTRY glColor3s( GLshort red, GLshort green, GLshort blue );

        [DllImport("opengl32")]
        public static extern void glColor3ub(byte red, byte green, byte blue);

        //GLAPI void APIENTRY glColor3ui( GLuint red, GLuint green, GLuint blue );
        //GLAPI void APIENTRY glColor3us( GLushort red, GLushort green, GLushort blue );
        //GLAPI void APIENTRY glColor4b( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha );
        //GLAPI void APIENTRY glColor4d( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha );

        [DllImport("opengl32")]
        public static extern void glColor4f(float red, float green, float blue, float alpha);

        //GLAPI void APIENTRY glColor4i( GLint red, GLint green, GLint blue, GLint alpha );
        //GLAPI void APIENTRY glColor4s( GLshort red, GLshort green, GLshort blue, GLshort alpha );

        [DllImport("opengl32")]
        public static extern void glColor4ub(byte red, byte green, byte blue, byte alpha);

        //GLAPI void APIENTRY glColor4ui( GLuint red, GLuint green, GLuint blue, GLuint alpha );
        //GLAPI void APIENTRY glColor4us( GLushort red, GLushort green, GLushort blue, GLushort alpha );
        //GLAPI void APIENTRY glColor3bv( const GLbyte *v );
        //GLAPI void APIENTRY glColor3dv( const GLdouble *v );
        //GLAPI void APIENTRY glColor3fv( const GLfloat *v );
        //GLAPI void APIENTRY glColor3iv( const GLint *v );
        //GLAPI void APIENTRY glColor3sv( const GLshort *v );
        //GLAPI void APIENTRY glColor3ubv( const GLubyte *v );
        //GLAPI void APIENTRY glColor3uiv( const GLuint *v );
        //GLAPI void APIENTRY glColor3usv( const GLushort *v );
        //GLAPI void APIENTRY glColor4bv( const GLbyte *v );
        //GLAPI void APIENTRY glColor4dv( const GLdouble *v );
        //GLAPI void APIENTRY glColor4fv( const GLfloat *v );
        //GLAPI void APIENTRY glColor4iv( const GLint *v );
        //GLAPI void APIENTRY glColor4sv( const GLshort *v );
        //GLAPI void APIENTRY glColor4ubv( const GLubyte *v );
        //GLAPI void APIENTRY glColor4uiv( const GLuint *v );
        //GLAPI void APIENTRY glColor4usv( const GLushort *v );
        //GLAPI void APIENTRY glTexCoord1d( GLdouble s );
        //GLAPI void APIENTRY glTexCoord1f( GLfloat s );
        //GLAPI void APIENTRY glTexCoord1i( GLint s );
        //GLAPI void APIENTRY glTexCoord1s( GLshort s );
        //GLAPI void APIENTRY glTexCoord2d( GLdouble s, GLdouble t );

        [DllImport("opengl32")]
        public static extern void glTexCoord2f(float s, float t);

        //GLAPI void APIENTRY glTexCoord2i( GLint s, GLint t );
        //GLAPI void APIENTRY glTexCoord2s( GLshort s, GLshort t );
        //GLAPI void APIENTRY glTexCoord3d( GLdouble s, GLdouble t, GLdouble r );
        //GLAPI void APIENTRY glTexCoord3f( GLfloat s, GLfloat t, GLfloat r );
        //GLAPI void APIENTRY glTexCoord3i( GLint s, GLint t, GLint r );
        //GLAPI void APIENTRY glTexCoord3s( GLshort s, GLshort t, GLshort r );
        //GLAPI void APIENTRY glTexCoord4d( GLdouble s, GLdouble t, GLdouble r, GLdouble q );
        //GLAPI void APIENTRY glTexCoord4f( GLfloat s, GLfloat t, GLfloat r, GLfloat q );
        //GLAPI void APIENTRY glTexCoord4i( GLint s, GLint t, GLint r, GLint q );
        //GLAPI void APIENTRY glTexCoord4s( GLshort s, GLshort t, GLshort r, GLshort q );
        //GLAPI void APIENTRY glTexCoord1dv( const GLdouble *v );
        //GLAPI void APIENTRY glTexCoord1fv( const GLfloat *v );
        //GLAPI void APIENTRY glTexCoord1iv( const GLint *v );
        //GLAPI void APIENTRY glTexCoord1sv( const GLshort *v );
        //GLAPI void APIENTRY glTexCoord2dv( const GLdouble *v );
        //GLAPI void APIENTRY glTexCoord2fv( const GLfloat *v );
        //GLAPI void APIENTRY glTexCoord2iv( const GLint *v );
        //GLAPI void APIENTRY glTexCoord2sv( const GLshort *v );
        //GLAPI void APIENTRY glTexCoord3dv( const GLdouble *v );
        //GLAPI void APIENTRY glTexCoord3fv( const GLfloat *v );
        //GLAPI void APIENTRY glTexCoord3iv( const GLint *v );
        //GLAPI void APIENTRY glTexCoord3sv( const GLshort *v );
        //GLAPI void APIENTRY glTexCoord4dv( const GLdouble *v );
        //GLAPI void APIENTRY glTexCoord4fv( const GLfloat *v );
        //GLAPI void APIENTRY glTexCoord4iv( const GLint *v );
        //GLAPI void APIENTRY glTexCoord4sv( const GLshort *v );
        //GLAPI void APIENTRY glRasterPos2d( GLdouble x, GLdouble y );
        //GLAPI void APIENTRY glRasterPos2f( GLfloat x, GLfloat y );
        //GLAPI void APIENTRY glRasterPos2i( GLint x, GLint y );
        //GLAPI void APIENTRY glRasterPos2s( GLshort x, GLshort y );
        //GLAPI void APIENTRY glRasterPos3d( GLdouble x, GLdouble y, GLdouble z );
        //GLAPI void APIENTRY glRasterPos3f( GLfloat x, GLfloat y, GLfloat z );
        //GLAPI void APIENTRY glRasterPos3i( GLint x, GLint y, GLint z );
        //GLAPI void APIENTRY glRasterPos3s( GLshort x, GLshort y, GLshort z );
        //GLAPI void APIENTRY glRasterPos4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
        //GLAPI void APIENTRY glRasterPos4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
        //GLAPI void APIENTRY glRasterPos4i( GLint x, GLint y, GLint z, GLint w );
        //GLAPI void APIENTRY glRasterPos4s( GLshort x, GLshort y, GLshort z, GLshort w );
        //GLAPI void APIENTRY glRasterPos2dv( const GLdouble *v );
        //GLAPI void APIENTRY glRasterPos2fv( const GLfloat *v );
        //GLAPI void APIENTRY glRasterPos2iv( const GLint *v );
        //GLAPI void APIENTRY glRasterPos2sv( const GLshort *v );
        //GLAPI void APIENTRY glRasterPos3dv( const GLdouble *v );
        //GLAPI void APIENTRY glRasterPos3fv( const GLfloat *v );
        //GLAPI void APIENTRY glRasterPos3iv( const GLint *v );
        //GLAPI void APIENTRY glRasterPos3sv( const GLshort *v );
        //GLAPI void APIENTRY glRasterPos4dv( const GLdouble *v );
        //GLAPI void APIENTRY glRasterPos4fv( const GLfloat *v );
        //GLAPI void APIENTRY glRasterPos4iv( const GLint *v );
        //GLAPI void APIENTRY glRasterPos4sv( const GLshort *v );
        //GLAPI void APIENTRY glRectd( GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 );
        //GLAPI void APIENTRY glRectf( GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 );
        //GLAPI void APIENTRY glRecti( GLint x1, GLint y1, GLint x2, GLint y2 );
        //GLAPI void APIENTRY glRects( GLshort x1, GLshort y1, GLshort x2, GLshort y2 );
        //GLAPI void APIENTRY glRectdv( const GLdouble *v1, const GLdouble *v2 );
        //GLAPI void APIENTRY glRectfv( const GLfloat *v1, const GLfloat *v2 );
        //GLAPI void APIENTRY glRectiv( const GLint *v1, const GLint *v2 );
        //GLAPI void APIENTRY glRectsv( const GLshort *v1, const GLshort *v2 );

        #endregion

        ///* Lighting */
        //GLAPI void APIENTRY glShadeModel( GLenum mode );
        //GLAPI void APIENTRY glLightf( GLenum light, GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glLighti( GLenum light, GLenum pname, GLint param );
        //GLAPI void APIENTRY glLightfv( GLenum light, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glLightiv( GLenum light, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glGetLightfv( GLenum light, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetLightiv( GLenum light, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glLightModelf( GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glLightModeli( GLenum pname, GLint param );
        //GLAPI void APIENTRY glLightModelfv( GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glLightModeliv( GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glMaterialf( GLenum face, GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glMateriali( GLenum face, GLenum pname, GLint param );
        //GLAPI void APIENTRY glMaterialfv( GLenum face, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glMaterialiv( GLenum face, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glGetMaterialfv( GLenum face, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetMaterialiv( GLenum face, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glColorMaterial( GLenum face, GLenum mode );

        ///* Raster functions */
        //GLAPI void APIENTRY glPixelZoom( GLfloat xfactor, GLfloat yfactor );
        //GLAPI void APIENTRY glPixelStoref( GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glPixelStorei( GLenum pname, GLint param );
        //GLAPI void APIENTRY glPixelTransferf( GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glPixelTransferi( GLenum pname, GLint param );
        //GLAPI void APIENTRY glPixelMapfv( GLenum map, GLint mapsize, const GLfloat *values );
        //GLAPI void APIENTRY glPixelMapuiv( GLenum map, GLint mapsize, const GLuint *values );
        //GLAPI void APIENTRY glPixelMapusv( GLenum map, GLint mapsize, const GLushort *values );
        //GLAPI void APIENTRY glGetPixelMapfv( GLenum map, GLfloat *values );
        //GLAPI void APIENTRY glGetPixelMapuiv( GLenum map, GLuint *values );
        //GLAPI void APIENTRY glGetPixelMapusv( GLenum map, GLushort *values );
        //GLAPI void APIENTRY glBitmap( GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap );
        //GLAPI void APIENTRY glReadPixels( GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels );
        //GLAPI void APIENTRY glDrawPixels( GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glCopyPixels( GLint x, GLint y, GLsizei width, GLsizei height, GLenum type );

        ///* Stenciling */
        //GLAPI void APIENTRY glStencilFunc( GLenum func, GLint ref, GLuint mask );
        //GLAPI void APIENTRY glStencilMask( GLuint mask );
        //GLAPI void APIENTRY glStencilOp( GLenum fail, GLenum zfail, GLenum zpass );
        //GLAPI void APIENTRY glClearStencil( GLint s );

        ///* Texture mapping */
        //GLAPI void APIENTRY glTexGend( GLenum coord, GLenum pname, GLdouble param );
        //GLAPI void APIENTRY glTexGenf( GLenum coord, GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glTexGeni( GLenum coord, GLenum pname, GLint param );
        //GLAPI void APIENTRY glTexGendv( GLenum coord, GLenum pname, const GLdouble *params );
        //GLAPI void APIENTRY glTexGenfv( GLenum coord, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glTexGeniv( GLenum coord, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glGetTexGendv( GLenum coord, GLenum pname, GLdouble *params );
        //GLAPI void APIENTRY glGetTexGenfv( GLenum coord, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetTexGeniv( GLenum coord, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glTexEnvf( GLenum target, GLenum pname, GLfloat param );

        [DllImport("opengl32")]
        public static extern void glTexEnvi(uint target, uint pname, int param);

        //GLAPI void APIENTRY glTexEnvfv( GLenum target, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glTexEnviv( GLenum target, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glGetTexEnvfv( GLenum target, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetTexEnviv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glTexParameterf( GLenum target, GLenum pname, GLfloat param );

        [DllImport("opengl32")]
        public static extern void glTexParameteri(uint target, uint pname, int param);

        //GLAPI void APIENTRY glTexParameterfv( GLenum target, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glTexParameteriv( GLenum target, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glGetTexParameterfv( GLenum target, GLenum pname, GLfloat *params);
        //GLAPI void APIENTRY glGetTexParameteriv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glGetTexLevelParameterfv( GLenum target, GLint level, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetTexLevelParameteriv( GLenum target, GLint level, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glTexImage1D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glTexImage2D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glGetTexImage( GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels );

        ///* Evaluators */
        //GLAPI void APIENTRY glMap1d( GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points );
        //GLAPI void APIENTRY glMap1f( GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points );
        //GLAPI void APIENTRY glMap2d( GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points );
        //GLAPI void APIENTRY glMap2f( GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points );
        //GLAPI void APIENTRY glGetMapdv( GLenum target, GLenum query, GLdouble *v );
        //GLAPI void APIENTRY glGetMapfv( GLenum target, GLenum query, GLfloat *v );
        //GLAPI void APIENTRY glGetMapiv( GLenum target, GLenum query, GLint *v );
        //GLAPI void APIENTRY glEvalCoord1d( GLdouble u );
        //GLAPI void APIENTRY glEvalCoord1f( GLfloat u );
        //GLAPI void APIENTRY glEvalCoord1dv( const GLdouble *u );
        //GLAPI void APIENTRY glEvalCoord1fv( const GLfloat *u );
        //GLAPI void APIENTRY glEvalCoord2d( GLdouble u, GLdouble v );
        //GLAPI void APIENTRY glEvalCoord2f( GLfloat u, GLfloat v );
        //GLAPI void APIENTRY glEvalCoord2dv( const GLdouble *u );
        //GLAPI void APIENTRY glEvalCoord2fv( const GLfloat *u );
        //GLAPI void APIENTRY glMapGrid1d( GLint un, GLdouble u1, GLdouble u2 );
        //GLAPI void APIENTRY glMapGrid1f( GLint un, GLfloat u1, GLfloat u2 );
        //GLAPI void APIENTRY glMapGrid2d( GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2 );
        //GLAPI void APIENTRY glMapGrid2f( GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2 );
        //GLAPI void APIENTRY glEvalPoint1( GLint i );
        //GLAPI void APIENTRY glEvalPoint2( GLint i, GLint j );
        //GLAPI void APIENTRY glEvalMesh1( GLenum mode, GLint i1, GLint i2 );
        //GLAPI void APIENTRY glEvalMesh2( GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 );

        ///* Fog */
        //GLAPI void APIENTRY glFogf( GLenum pname, GLfloat param );
        //GLAPI void APIENTRY glFogi( GLenum pname, GLint param );
        //GLAPI void APIENTRY glFogfv( GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glFogiv( GLenum pname, const GLint *params );

        ///* Selection and Feedback */
        //GLAPI void APIENTRY glFeedbackBuffer( GLsizei size, GLenum type, GLfloat *buffer );
        //GLAPI void APIENTRY glPassThrough( GLfloat token );
        //GLAPI void APIENTRY glSelectBuffer( GLsizei size, GLuint *buffer );
        //GLAPI void APIENTRY glInitNames( void );
        //GLAPI void APIENTRY glLoadName( GLuint name );
        //GLAPI void APIENTRY glPushName( GLuint name );
        //GLAPI void APIENTRY glPopName( void );


        ///* 1.1 functions */

        #region texture objects

        //GLAPI void APIENTRY glGenTextures( GLsizei n, GLuint *textures );
        //GLAPI void APIENTRY glDeleteTextures( GLsizei n, const GLuint *textures);

        [DllImport("opengl32")]
        public static extern void glBindTexture(uint target, uint texture);

        //GLAPI void APIENTRY glPrioritizeTextures( GLsizei n, const GLuint *textures, const GLclampf *priorities );
        //GLAPI GLboolean APIENTRY glAreTexturesResident( GLsizei n, const GLuint *textures, GLboolean *residences );
        //GLAPI GLboolean APIENTRY glIsTexture( GLuint texture );

        #endregion

        ///* texture mapping */
        //GLAPI void APIENTRY glTexSubImage1D( GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glTexSubImage2D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glCopyTexImage1D( GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border );
        //GLAPI void APIENTRY glCopyTexImage2D( GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border );
        //GLAPI void APIENTRY glCopyTexSubImage1D( GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width );
        //GLAPI void APIENTRY glCopyTexSubImage2D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height );
        ///* vertex arrays */
        //GLAPI void APIENTRY glVertexPointer( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glNormalPointer( GLenum type, GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glColorPointer( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glIndexPointer( GLenum type, GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glTexCoordPointer( GLint size, GLenum type, GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glEdgeFlagPointer( GLsizei stride, const GLvoid *ptr );
        //GLAPI void APIENTRY glGetPointerv( GLenum pname, GLvoid **params );
        //GLAPI void APIENTRY glArrayElement( GLint i );
        //GLAPI void APIENTRY glDrawArrays( GLenum mode, GLint first, GLsizei count );
        //GLAPI void APIENTRY glDrawElements( GLenum mode, GLsizei count, GLenum type, const GLvoid *indices );
        //GLAPI void APIENTRY glInterleavedArrays( GLenum format, GLsizei stride, const GLvoid *pointer );



        ///* Under Windows, we do not define OpenGL 1.2 & 1.3 functionality, since
        //   it is treated as extensions (defined in glext.h) */
        //#if !defined(__WIN32__)

        ///* 1.2 functions */
        //GLAPI void APIENTRY glDrawRangeElements( GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices );
        //GLAPI void APIENTRY glTexImage3D( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels );
        //GLAPI void APIENTRY glTexSubImage3D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
        //GLAPI void APIENTRY glCopyTexSubImage3D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height );

        ///* 1.2 imaging extension functions */
        //GLAPI void APIENTRY glColorTable( GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table );
        //GLAPI void APIENTRY glColorSubTable( GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data );
        //GLAPI void APIENTRY glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params);
        //GLAPI void APIENTRY glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params);
        //GLAPI void APIENTRY glCopyColorSubTable( GLenum target, GLsizei start, GLint x, GLint y, GLsizei width );
        //GLAPI void APIENTRY glCopyColorTable( GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width );
        //GLAPI void APIENTRY glGetColorTable( GLenum target, GLenum format, GLenum type, GLvoid *table );
        //GLAPI void APIENTRY glGetColorTableParameterfv( GLenum target, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetColorTableParameteriv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glBlendEquation( GLenum mode );
        //GLAPI void APIENTRY glBlendColor( GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha );
        //GLAPI void APIENTRY glHistogram( GLenum target, GLsizei width, GLenum internalformat, GLboolean sink );
        //GLAPI void APIENTRY glResetHistogram( GLenum target );
        //GLAPI void APIENTRY glGetHistogram( GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values );
        //GLAPI void APIENTRY glGetHistogramParameterfv( GLenum target, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetHistogramParameteriv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glMinmax( GLenum target, GLenum internalformat, GLboolean sink );
        //GLAPI void APIENTRY glResetMinmax( GLenum target );
        //GLAPI void APIENTRY glGetMinmax( GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values );
        //GLAPI void APIENTRY glGetMinmaxParameterfv( GLenum target, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetMinmaxParameteriv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glConvolutionFilter1D( GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image );
        //GLAPI void APIENTRY glConvolutionFilter2D( GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image );
        //GLAPI void APIENTRY glConvolutionParameterf( GLenum target, GLenum pname, GLfloat params );
        //GLAPI void APIENTRY glConvolutionParameterfv( GLenum target, GLenum pname, const GLfloat *params );
        //GLAPI void APIENTRY glConvolutionParameteri( GLenum target, GLenum pname, GLint params );
        //GLAPI void APIENTRY glConvolutionParameteriv( GLenum target, GLenum pname, const GLint *params );
        //GLAPI void APIENTRY glCopyConvolutionFilter1D( GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width );
        //GLAPI void APIENTRY glCopyConvolutionFilter2D( GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
        //GLAPI void APIENTRY glGetConvolutionFilter( GLenum target, GLenum format, GLenum type, GLvoid *image );
        //GLAPI void APIENTRY glGetConvolutionParameterfv( GLenum target, GLenum pname, GLfloat *params );
        //GLAPI void APIENTRY glGetConvolutionParameteriv( GLenum target, GLenum pname, GLint *params );
        //GLAPI void APIENTRY glSeparableFilter2D( GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column );
        //GLAPI void APIENTRY glGetSeparableFilter( GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span );

        ///* 1.3 functions */
        //GLAPI void APIENTRY glActiveTexture( GLenum texture );
        //GLAPI void APIENTRY glClientActiveTexture( GLenum texture );
        //GLAPI void APIENTRY glCompressedTexImage1D( GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glCompressedTexImage2D( GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glCompressedTexImage3D( GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glCompressedTexSubImage1D( GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glCompressedTexSubImage2D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glCompressedTexSubImage3D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data );
        //GLAPI void APIENTRY glGetCompressedTexImage( GLenum target, GLint lod, GLvoid *img );
        //GLAPI void APIENTRY glMultiTexCoord1d( GLenum target, GLdouble s );
        //GLAPI void APIENTRY glMultiTexCoord1dv( GLenum target, const GLdouble *v );
        //GLAPI void APIENTRY glMultiTexCoord1f( GLenum target, GLfloat s );
        //GLAPI void APIENTRY glMultiTexCoord1fv( GLenum target, const GLfloat *v );
        //GLAPI void APIENTRY glMultiTexCoord1i( GLenum target, GLint s );
        //GLAPI void APIENTRY glMultiTexCoord1iv( GLenum target, const GLint *v );
        //GLAPI void APIENTRY glMultiTexCoord1s( GLenum target, GLshort s );
        //GLAPI void APIENTRY glMultiTexCoord1sv( GLenum target, const GLshort *v );
        //GLAPI void APIENTRY glMultiTexCoord2d( GLenum target, GLdouble s, GLdouble t );
        //GLAPI void APIENTRY glMultiTexCoord2dv( GLenum target, const GLdouble *v );
        //GLAPI void APIENTRY glMultiTexCoord2f( GLenum target, GLfloat s, GLfloat t );
        //GLAPI void APIENTRY glMultiTexCoord2fv( GLenum target, const GLfloat *v );
        //GLAPI void APIENTRY glMultiTexCoord2i( GLenum target, GLint s, GLint t );
        //GLAPI void APIENTRY glMultiTexCoord2iv( GLenum target, const GLint *v );
        //GLAPI void APIENTRY glMultiTexCoord2s( GLenum target, GLshort s, GLshort t );
        //GLAPI void APIENTRY glMultiTexCoord2sv( GLenum target, const GLshort *v );
        //GLAPI void APIENTRY glMultiTexCoord3d( GLenum target, GLdouble s, GLdouble t, GLdouble r );
        //GLAPI void APIENTRY glMultiTexCoord3dv( GLenum target, const GLdouble *v );
        //GLAPI void APIENTRY glMultiTexCoord3f( GLenum target, GLfloat s, GLfloat t, GLfloat r );
        //GLAPI void APIENTRY glMultiTexCoord3fv( GLenum target, const GLfloat *v );
        //GLAPI void APIENTRY glMultiTexCoord3i( GLenum target, GLint s, GLint t, GLint r );
        //GLAPI void APIENTRY glMultiTexCoord3iv( GLenum target, const GLint *v );
        //GLAPI void APIENTRY glMultiTexCoord3s( GLenum target, GLshort s, GLshort t, GLshort r );
        //GLAPI void APIENTRY glMultiTexCoord3sv( GLenum target, const GLshort *v );
        //GLAPI void APIENTRY glMultiTexCoord4d( GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q );
        //GLAPI void APIENTRY glMultiTexCoord4dv( GLenum target, const GLdouble *v );
        //GLAPI void APIENTRY glMultiTexCoord4f( GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q );
        //GLAPI void APIENTRY glMultiTexCoord4fv( GLenum target, const GLfloat *v );
        //GLAPI void APIENTRY glMultiTexCoord4i( GLenum target, GLint s, GLint t, GLint r, GLint q );
        //GLAPI void APIENTRY glMultiTexCoord4iv( GLenum target, const GLint *v );
        //GLAPI void APIENTRY glMultiTexCoord4s( GLenum target, GLshort s, GLshort t, GLshort r, GLshort q );
        //GLAPI void APIENTRY glMultiTexCoord4sv( GLenum target, const GLshort *v );
        //GLAPI void APIENTRY glLoadTransposeMatrixd( const GLdouble m[16] );
        //GLAPI void APIENTRY glLoadTransposeMatrixf( const GLfloat m[16] );
        //GLAPI void APIENTRY glMultTransposeMatrixd( const GLdouble m[16] );
        //GLAPI void APIENTRY glMultTransposeMatrixf( const GLfloat m[16] );
        //GLAPI void APIENTRY glSampleCoverage( GLclampf value, GLboolean invert );
        //GLAPI void APIENTRY glSamplePass( GLenum pass );

        #endregion

        [DllImport("opengl32")]
        public static extern void glBegin(uint mode);

        [DllImport("opengl32")]
        public static extern void glClear(uint mask);

        [DllImport("opengl32")]
        public static extern void glColor3f(float red, float green, float blue);

        [DllImport("opengl32")]
        public static extern void glCullFace(uint mode);

        [DllImport("opengl32")]
        public static extern void glEnd();

        [DllImport("opengl32")]
        public static extern void glFlush();

        [DllImport("opengl32")]
        public static extern void glFrustum(double left, double right, double bottom, double top, double nearVal, double farVal);

        [DllImport("opengl32")]
        public static extern void glLoadIdentity();

        [DllImport("opengl32")]
        public static extern void glMatrixMode(uint mode);

        [DllImport("opengl32")]
        public static extern void glPopMatrix();

        [DllImport("opengl32")]
        public static extern void glPushMatrix();

        [DllImport("opengl32")]
        public static extern void glRotatef(float angle, float x, float y, float z);

        [DllImport("opengl32")]
        public static extern void glShadeModel(uint mode);

        [DllImport("opengl32")]
        public static extern void glTranslatef(float x, float y, float z);

        [DllImport("opengl32")]
        public static extern void glVertex3d(double x, double y, double z);
    }
}
